/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.MapBuilder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;

public interface MapResult
extends Map<String, Object> {
    default public <T> T first() {
        return Objects.requireNonNull(this.first(null));
    }

    default public <T> T first(T def) {
        return (T)Iterables.getFirst(this.values(), def);
    }

    default public Map.Entry<String, Object> firstEntry() {
        return Objects.requireNonNull(this.firstEntry(null));
    }

    default public Map.Entry<String, Object> firstEntry(Map.Entry<String, Object> def) {
        return (Map.Entry)Iterables.getFirst(this.entrySet(), def);
    }

    default public String optStr(String prop) {
        return this.stringVal(prop, false, null);
    }

    default public String optStr(String prop, String defVal) {
        return this.stringVal(prop, false, defVal);
    }

    default public String reqdStr(String prop) {
        return this.stringVal(prop, true, null);
    }

    default public boolean boolVal(String prop, boolean defVal) {
        return this.asValue(prop, Boolean.class, defVal);
    }

    default public int intVal(String prop, int defVal) {
        return this.asValue(prop, Integer.class, defVal);
    }

    default public long longVal(String prop, long defVal) {
        return this.asValue(prop, Long.class, defVal);
    }

    default public Long longStrVal(String prop) {
        Object value = this.get(prop);
        return value == null ? null : Long.valueOf(value instanceof Number ? ((Number)value).longValue() : Long.parseLong(String.valueOf(value)));
    }

    default public long longStrVal(String prop, long defaultValue) {
        Object value = this.get(prop);
        return value == null ? defaultValue : (value instanceof Number ? ((Number)value).longValue() : Long.parseLong(String.valueOf(value)));
    }

    default public String stringVal(String prop, boolean required, String defVal) {
        return this.getOrDefault(required ? this.reqdProp(prop) : prop, defVal);
    }

    default public <T> T optValue(String prop) {
        return (T)this.get(prop);
    }

    default public <T> T optValue(String prop, T defValue) {
        return this.getOrDefault(prop, defValue);
    }

    default public <T> T reqdValue(String prop) {
        return (T)this.get(this.reqdProp(prop));
    }

    default public <T> T asValue(String prop, Class<T> clazz, T defVal) {
        return clazz.cast(this.getOrDefault(prop, defVal));
    }

    default public String reqdProp(String prop) {
        return Assertions.checkContains(this, prop);
    }

    default public <T> T removeVal(String prop) {
        return (T)this.remove(this.reqdProp(prop));
    }

    default public <T> T removeIfExists(String prop) {
        return this.removeIfExists(prop, null);
    }

    default public <T> T removeIfExists(String prop, T defVl) {
        return (T)(this.containsKey(prop) ? this.remove(prop) : defVl);
    }

    public static ImmutableMapResult immutableResult() {
        return new ImmutableMapResult((ImmutableMap<String, Object>)ImmutableMap.of());
    }

    public static ImmutableMapResult immutableResult(String k1, Object v1) {
        return (ImmutableMapResult)((MapBuilder.ImmutableMapBuilder)MapResult.immutableResultBuilder().put((Object)k1, v1)).result();
    }

    public static ImmutableMapResult immutableResult(String k1, Object v1, String k2, Object v2) {
        return (ImmutableMapResult)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)MapResult.immutableResultBuilder().put((Object)k1, v1)).put(k2, v2)).result();
    }

    public static ImmutableMapResult immutableResult(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        return (ImmutableMapResult)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)MapResult.immutableResultBuilder().put((Object)k1, v1)).put(k2, v2)).put(k3, v3)).result();
    }

    public static ImmutableMapResult immutableResult(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        return (ImmutableMapResult)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)MapResult.immutableResultBuilder().put((Object)k1, v1)).put(k2, v2)).put(k3, v3)).put(k4, v4)).result();
    }

    public static ImmutableMapResult immutableResult(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        return (ImmutableMapResult)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)((MapBuilder.ImmutableMapBuilder)MapResult.immutableResultBuilder().put((Object)k1, v1)).put(k2, v2)).put(k3, v3)).put(k4, v4)).put(k5, v5)).result();
    }

    public static ImmutableMapResult immutableResult(Map<String, Object> map) {
        return (ImmutableMapResult)((MapBuilder.ImmutableMapBuilder)MapResult.immutableResultBuilder().putAll((Map)map)).result();
    }

    public static MapBuilder.ImmutableMapBuilder<String, Object> immutableResultBuilder() {
        return MapBuilder.immutableMapBuilder();
    }

    public static MapResult simpleResult() {
        return new SimpleMapResult();
    }

    public static MapResult simpleResult(String k1, Object v1) {
        return ((MapBuilder.SimpleMapBuilder)MapResult.simpleResultBuilder().put((Object)k1, v1)).result();
    }

    public static MapResult simpleResult(String k1, Object v1, String k2, Object v2) {
        return ((MapBuilder.SimpleMapBuilder)((MapBuilder.SimpleMapBuilder)MapResult.simpleResultBuilder().put((Object)k1, v1)).put(k2, v2)).result();
    }

    public static MapResult simpleResult(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        return ((MapBuilder.SimpleMapBuilder)((MapBuilder.SimpleMapBuilder)((MapBuilder.SimpleMapBuilder)MapResult.simpleResultBuilder().put((Object)k1, v1)).put(k2, v2)).put(k3, v3)).result();
    }

    public static MapResult simpleResult(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        return ((MapBuilder.SimpleMapBuilder)((MapBuilder.SimpleMapBuilder)((MapBuilder.SimpleMapBuilder)((MapBuilder.SimpleMapBuilder)MapResult.simpleResultBuilder().put((Object)k1, v1)).put(k2, v2)).put(k3, v3)).put(k4, v4)).result();
    }

    public static MapResult simpleResult(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        return ((MapBuilder.SimpleMapBuilder)((MapBuilder.SimpleMapBuilder)((MapBuilder.SimpleMapBuilder)((MapBuilder.SimpleMapBuilder)((MapBuilder.SimpleMapBuilder)MapResult.simpleResultBuilder().put((Object)k1, v1)).put(k2, v2)).put(k3, v3)).put(k4, v4)).put(k5, v5)).result();
    }

    public static MapResult simpleResult(Map<String, Object> map) {
        return ((MapBuilder.SimpleMapBuilder)MapResult.simpleResultBuilder().putAll((Map)map)).result();
    }

    public static MapBuilder.SimpleMapBuilder<String, Object> simpleResultBuilder() {
        return MapBuilder.simpleMapBuilder(SimpleMapResult::new);
    }

    public static interface ImmutableResult
    extends MapResult {
        public ImmutableMapResult immutable();
    }

    public static class ImmutableMapResult
    implements ImmutableResult {
        @NonNull
        private final ImmutableMap<String, Object> delegate;

        @Override
        public boolean equals(Object object) {
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public ImmutableMapResult immutable() {
            return this;
        }

        public ImmutableMapResult(@NonNull ImmutableMap<String, Object> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate");
            }
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public Object put(String key, Object value) {
            return this.delegate.put((Object)key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.delegate.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            this.delegate.putAll(m);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.delegate.entrySet();
        }

        private static interface MapInclude {
            public int size();

            public boolean isEmpty();

            public boolean containsKey(Object var1);

            public boolean containsValue(Object var1);

            public Object get(Object var1);

            public Object put(String var1, Object var2);

            public Object remove(Object var1);

            public void putAll(Map<? extends String, ?> var1);

            public void clear();

            public Set<String> keySet();

            public Collection<Object> values();

            public Set<Map.Entry<String, Object>> entrySet();
        }
    }

    public static class SimpleMapResult
    extends LinkedHashMap<String, Object>
    implements ImmutableResult {
        public SimpleMapResult(Map<String, Object> m) {
            super(m);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public Object put(String key, Object value) {
            if (value != null) {
                return super.put(key, value);
            }
            return null;
        }

        @Override
        public Object putIfAbsent(String key, Object value) {
            if (value != null) {
                return super.putIfAbsent(key, value);
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ?> map) {
            for (Map.Entry<String, ?> e : map.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public ImmutableMapResult immutable() {
            return new ImmutableMapResult((ImmutableMap<String, Object>)ImmutableMap.copyOf((Map)this));
        }

        public SimpleMapResult() {
        }
    }
}

