/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.ReflectionUtil;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

public interface Builder<T> {
    public T build();

    public static <T, C extends Builder<T>> T buildWith(MapResult mapResult, Class<C> clazz) {
        Builder builder = (Builder)ReflectionUtil.create(clazz);
        for (Field field : clazz.getDeclaredFields()) {
            Object value = mapResult.get(field.getName());
            if (value == null) {
                value = mapResult.get(NullUtil.nonNullFn(ReflectionUtil.annotation(field, Name.class), Name::value, "_$"));
            }
            if (value == null) continue;
            Class<Iterable> valueClass = value instanceof Collection ? Iterable.class : (value instanceof Map ? Map.class : NullUtil.nonNullFn(ReflectionUtil.declaredField(clazz, field.getName()), Field::getType, Void.class));
            ReflectionUtil.safeInvoke(ReflectionUtil.declaredMethod(clazz, field.getName(), new Class[]{valueClass}), (Object)builder, value);
        }
        return builder.build();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Name {
        public String value();
    }
}

