/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.esjwt.realm;

import io.polyglotted.esjwt.impl.JsonWebToken;
import io.polyglotted.esjwt.impl.JwtValidator;
import io.polyglotted.esjwt.impl.JwtVerifier;
import io.polyglotted.esjwt.realm.BearerToken;
import java.io.IOException;
import java.time.Clock;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.user.User;

public class JwtRealm
extends Realm {
    public static final String TYPE = "esjwt";
    private final String jwksUrl;
    private final String groupsField;

    JwtRealm(RealmConfig config) {
        super(TYPE, config);
        this.jwksUrl = config.settings().get("jwksUrl");
        this.groupsField = config.settings().get("groupsField", "cognito:groups");
        this.logger.info("loaded x-pack-plugin [esjwt]");
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof BearerToken;
    }

    public AuthenticationToken token(ThreadContext context) {
        String authHeader = context.getHeader("Authorization");
        return authHeader != null && authHeader.startsWith("Bearer ") ? BearerToken.bearerToken(authHeader.substring(7)) : null;
    }

    public void authenticate(AuthenticationToken authenticationToken, ActionListener<AuthenticationResult> listener) {
        try {
            JsonWebToken token = JsonWebToken.parseJwt(authenticationToken.credentials().toString());
            if (this.jwksUrl != null) {
                JwtVerifier.verifyRs256(this.jwksUrl, token);
            }
            User user = JwtValidator.validateJwt(Clock.systemUTC(), token, this.groupsField);
            listener.onResponse((Object)AuthenticationResult.success((User)user));
        }
        catch (JwtValidator.ValidityException | JwtVerifier.VerificationException ex) {
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)"failed to validate", (Exception)ex));
        }
        catch (IOException ex) {
            listener.onFailure((Exception)ex);
        }
    }

    public void lookupUser(String username, ActionListener<User> listener) {
    }
}

