/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.esjwt.impl;

import io.polyglotted.esjwt.impl.CommonUtil;
import io.polyglotted.esjwt.impl.JsonWebToken;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;

public abstract class JwtVerifier {
    static final String RSA = "RSA";
    static final String RSA_ALGO = "SHA256withRSA";

    public static void verifyRs256(String jwksUrl, JsonWebToken token) throws VerificationException {
        Map<String, Object> key = JwtVerifier.fetchJwks(jwksUrl).get(token.keyCode());
        if (key == null) {
            throw new VerificationException("could not find public key for " + token.keyCode());
        }
        PublicKey publicKey = JwtVerifier.getPublicKey((String)CommonUtil.deepGet(key, "kty"), (String)CommonUtil.deepGet(key, "n"), (String)CommonUtil.deepGet(key, "e"));
        if (publicKey == null) {
            return;
        }
        if (!JwtVerifier.verifySignatureFor(publicKey, token.contentBytes(), token.signatureBytes())) {
            throw new VerificationException("invalid signature");
        }
    }

    private static boolean verifySignatureFor(PublicKey publicKey, byte[] contentBytes, byte[] signatureBytes) throws VerificationException {
        try {
            Signature s = Signature.getInstance(RSA_ALGO);
            s.initVerify(publicKey);
            s.update(contentBytes);
            return s.verify(signatureBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new VerificationException("failed signature verify", ex);
        }
    }

    static PublicKey getPublicKey(String type, String nVal, String eVal) throws VerificationException {
        if (!RSA.equalsIgnoreCase(type)) {
            return null;
        }
        try {
            KeyFactory kf = KeyFactory.getInstance(RSA);
            BigInteger modulus = new BigInteger(1, Base64.decodeBase64((String)nVal));
            BigInteger exponent = new BigInteger(1, Base64.decodeBase64((String)eVal));
            return kf.generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new VerificationException("Unable to generate public key", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Map<String, Object>> fetchJwks(String uri) throws VerificationException {
        LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>();
        try (CloseableHttpClient httpClient = CommonUtil.httpClient();){
            Map<String, Object> map = CommonUtil.parseJson(CommonUtil.readFrom((HttpClient)httpClient, (HttpRequestBase)new HttpGet(uri)));
            List keys = (List)map.get("keys");
            for (Map key : keys) {
                result.put(CommonUtil.deepGet(key, "alg") + ":" + CommonUtil.deepGet(key, "kid"), key);
            }
            LinkedHashMap<String, Map> linkedHashMap = result;
            return linkedHashMap;
        }
        catch (IOException | HttpException ex) {
            throw new VerificationException("unable to fetch key from jwks", ex);
        }
    }

    public static class VerificationException
    extends Exception {
        VerificationException(String message) {
            super(message);
        }

        VerificationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

