/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.esjwt.impl;

import io.polyglotted.esjwt.impl.JsonWebToken;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import org.elasticsearch.xpack.core.security.user.User;

public abstract class JwtValidator {
    public static User validateJwt(Clock clock, JsonWebToken token, String groupsField) throws ValidityException {
        JwtValidator.validateBefore(clock, token.notBefore());
        JwtValidator.validateBefore(clock, token.issuedAt());
        JwtValidator.validateAfter(clock, token.expiresAt());
        return token.buildUser(groupsField);
    }

    static void validateBefore(Clock clock, Long time) throws ValidityException {
        if (time != null && time > clock.millis() + 1000L) {
            throw ValidityException.dateFail("time occurs in the past ", time);
        }
    }

    static void validateAfter(Clock clock, Long time) throws ValidityException {
        if (time != null && time < clock.millis() - 1000L) {
            throw ValidityException.dateFail("token has expired ", time.intValue());
        }
    }

    public static class ValidityException
    extends Exception {
        ValidityException(String message) {
            super(message);
        }

        static ValidityException dateFail(String message, long time) {
            return new ValidityException(message + Instant.ofEpochMilli(time).atOffset(ZoneOffset.UTC).toLocalDateTime());
        }
    }
}

