/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.esjwt.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentType;

public abstract class CommonUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFrom(HttpClient httpClient, HttpRequestBase requestBase) throws IOException, HttpException {
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)requestBase);
            int statusCode = response.getStatusLine().getStatusCode();
            CommonUtil.checkState(statusCode >= 200 && statusCode < 300, response.getStatusLine().getReasonPhrase());
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        finally {
            requestBase.releaseConnection();
        }
    }

    static CloseableHttpClient httpClient() {
        return HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(30000).build()).build();
    }

    private static void checkState(boolean status, String message) throws HttpException {
        if (!status) {
            throw new HttpException(message);
        }
    }

    static Map<String, Object> parseJson(String json) throws IOException {
        return XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, json).map();
    }

    static Map<String, Object> parseJson(byte[] bytes) throws IOException {
        return XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, bytes).map();
    }

    static <T> T deepGet(Map<String, Object> map, String property) {
        if (!property.contains(".")) {
            return CommonUtil.mapGet(map, property);
        }
        String[] parts = property.split("\\.");
        Map child = map;
        for (int i = 0; i < parts.length - 1; ++i) {
            if ((child = (Map)CommonUtil.mapGet(child, parts[i])) != null) continue;
            return null;
        }
        return CommonUtil.mapGet(child, parts[parts.length - 1]);
    }

    private static <T> T mapGet(Map<String, Object> map, String prop) {
        return (T)map.get(prop);
    }

    static Long asTime(Map<String, Object> map, String prop) {
        Integer integer = (Integer)map.get(prop);
        return integer == null ? null : Long.valueOf(integer.longValue() * 1000L);
    }
}

