/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.esjwt.realm;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.DefaultAuthenticationFailureHandler;

public class JwtAuthFailureHandler
extends DefaultAuthenticationFailureHandler {
    public ElasticsearchSecurityException failedAuthentication(RestRequest request, AuthenticationToken token, ThreadContext context) {
        return JwtAuthFailureHandler.buildJwtFailure(super.failedAuthentication(request, token, context));
    }

    public ElasticsearchSecurityException failedAuthentication(TransportMessage message, AuthenticationToken token, String action, ThreadContext context) {
        return JwtAuthFailureHandler.buildJwtFailure(super.failedAuthentication(message, token, action, context));
    }

    public ElasticsearchSecurityException missingToken(RestRequest request, ThreadContext context) {
        return JwtAuthFailureHandler.buildJwtFailure(super.missingToken(request, context));
    }

    public ElasticsearchSecurityException missingToken(TransportMessage message, String action, ThreadContext context) {
        return JwtAuthFailureHandler.buildJwtFailure(super.missingToken(message, action, context));
    }

    public ElasticsearchSecurityException exceptionProcessingRequest(RestRequest request, Exception e, ThreadContext context) {
        return JwtAuthFailureHandler.buildJwtFailure(super.exceptionProcessingRequest(request, e, context));
    }

    public ElasticsearchSecurityException exceptionProcessingRequest(TransportMessage message, String action, Exception e, ThreadContext context) {
        return JwtAuthFailureHandler.buildJwtFailure(super.exceptionProcessingRequest(message, action, e, context));
    }

    public ElasticsearchSecurityException authenticationRequired(String action, ThreadContext context) {
        return JwtAuthFailureHandler.buildJwtFailure(super.authenticationRequired(action, context));
    }

    private static ElasticsearchSecurityException buildJwtFailure(ElasticsearchSecurityException se) {
        se.addHeader("WWW-Authenticate", new String[]{"jwt-error"});
        return se;
    }
}

