/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.esjwt.impl;

import io.polyglotted.esjwt.impl.CommonUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.elasticsearch.xpack.core.security.user.User;

public final class JsonWebToken {
    private static Pattern EMAIL_REGEX = Pattern.compile("(?:[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?\\.)+[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[A-Za-z0-9-]*[A-Za-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])");
    private final Map<String, Object> header;
    private final Map<String, Object> payload;
    private final byte[] contentBytes;
    private final byte[] signatureBytes;

    private JsonWebToken(Map<String, Object> header, Map<String, Object> payload, byte[] contentBytes, byte[] signatureBytes) {
        this.header = header;
        this.payload = payload;
        this.contentBytes = contentBytes;
        this.signatureBytes = signatureBytes;
    }

    public static JsonWebToken parseJwt(String token) throws IOException {
        String[] parts = token.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("invalid token parts");
        }
        return new JsonWebToken(CommonUtil.parseJson(Base64.decodeBase64((String)parts[0])), CommonUtil.parseJson(Base64.decodeBase64((String)parts[1])), String.format(Locale.ENGLISH, "%s.%s", parts[0], parts[1]).getBytes(StandardCharsets.UTF_8), Base64.decodeBase64((String)parts[2]));
    }

    String keyCode() {
        return CommonUtil.deepGet(this.header, "alg") + ":" + CommonUtil.deepGet(this.header, "kid");
    }

    byte[] contentBytes() {
        return this.contentBytes;
    }

    byte[] signatureBytes() {
        return this.signatureBytes;
    }

    Long expiresAt() {
        return CommonUtil.asTime(this.payload, "exp");
    }

    Long notBefore() {
        return CommonUtil.asTime(this.payload, "nbf");
    }

    Long issuedAt() {
        return CommonUtil.asTime(this.payload, "iat");
    }

    User buildUser(String groupsField) {
        return new User(JsonWebToken.userId(this.payload), JsonWebToken.groupsToRoles(this.payload, groupsField), null, JsonWebToken.email(this.payload), this.payload, true);
    }

    private static String[] groupsToRoles(Map<String, Object> claims, String groupsField) {
        LinkedList<String> roles = new LinkedList<String>();
        roles.add("jwt_user");
        if (claims.containsKey(groupsField)) {
            List groups = (List)claims.get(groupsField);
            for (String group : groups) {
                roles.add(group.toLowerCase(Locale.ENGLISH));
            }
        }
        return roles.toArray(new String[roles.size()]);
    }

    private static String userId(Map<String, Object> claims) {
        return (String)claims.getOrDefault("uid", claims.get("sub"));
    }

    private static String email(Map<String, Object> claims) {
        String email = (String)claims.getOrDefault("sub", "");
        return EMAIL_REGEX.matcher(email).matches() ? email : null;
    }
}

