/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Shorthand;
import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.ParseValue;
import io.parsingdata.metal.data.Slice;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import io.parsingdata.metal.token.Token;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class Until
extends Token {
    public static final ValueExpression DEFAULT_INITIAL = Shorthand.con(0L);
    public static final ValueExpression DEFAULT_STEP = Shorthand.con(1L);
    public static final ValueExpression DEFAULT_MAX = Shorthand.con(Integer.MAX_VALUE);
    public final ValueExpression initialSize;
    public final ValueExpression stepSize;
    public final ValueExpression maxSize;
    public final Token terminator;

    public Until(String name, ValueExpression initialSize, ValueExpression stepSize, ValueExpression maxSize, Token terminator, Encoding encoding) {
        super(Util.checkNotEmpty(name, "name"), encoding);
        this.initialSize = initialSize == null ? DEFAULT_INITIAL : initialSize;
        this.stepSize = stepSize == null ? DEFAULT_STEP : stepSize;
        this.maxSize = maxSize == null ? DEFAULT_MAX : maxSize;
        this.terminator = Util.checkNotNull(terminator, "terminator");
    }

    @Override
    protected Optional<ParseState> parseImpl(Environment environment) {
        return this.handleInterval(environment, this.initialSize.eval(environment.parseState, environment.encoding), this.stepSize.eval(environment.parseState, environment.encoding), this.maxSize.eval(environment.parseState, environment.encoding)).computeResult();
    }

    private Trampoline<Optional<ParseState>> handleInterval(Environment environment, ImmutableList<Value> initialSizes, ImmutableList<Value> stepSizes, ImmutableList<Value> maxSizes) {
        if (this.checkNotValidList(initialSizes) || this.checkNotValidList(stepSizes) || this.checkNotValidList(maxSizes)) {
            return Trampoline.complete(Util::failure);
        }
        return this.iterate(environment, this.getNumeric(initialSizes), this.getNumeric(stepSizes), this.getNumeric(maxSizes)).computeResult().map(nextParseState -> Trampoline.complete(() -> Util.success(nextParseState))).orElseGet(() -> Trampoline.intermediate(() -> this.handleInterval(environment, initialSizes.tail, stepSizes.tail, maxSizes.tail)));
    }

    private Trampoline<Optional<ParseState>> iterate(Environment environment, BigInteger currentSize, BigInteger stepSize, BigInteger maxSize) {
        if (stepSize.compareTo(BigInteger.ZERO) == 0 || stepSize.compareTo(BigInteger.ZERO) > 0 && currentSize.compareTo(maxSize) > 0 || stepSize.compareTo(BigInteger.ZERO) < 0 && currentSize.compareTo(maxSize) < 0) {
            return Trampoline.complete(Util::failure);
        }
        return environment.parseState.slice(currentSize).map(slice -> this.parseSlice(environment, currentSize, stepSize, maxSize, (Slice)slice)).orElseGet(() -> Trampoline.complete(Util::failure));
    }

    private Trampoline<Optional<ParseState>> parseSlice(Environment environment, BigInteger currentSize, BigInteger stepSize, BigInteger maxSize, Slice slice) {
        return (currentSize.compareTo(BigInteger.ZERO) == 0 ? Optional.of(environment.parseState) : environment.parseState.add(new ParseValue(this.name, this, slice, environment.encoding)).seek(environment.parseState.offset.add(currentSize))).map(preparedParseState -> this.terminator.parse(environment.withParseState((ParseState)preparedParseState))).orElseGet(Util::failure).map(parsedParseState -> Trampoline.complete(() -> Util.success(parsedParseState))).orElseGet(() -> Trampoline.intermediate(() -> this.iterate(environment, currentSize.add(stepSize), stepSize, maxSize)));
    }

    private boolean checkNotValidList(ImmutableList<Value> list) {
        return list.isEmpty() || ((Value)list.head).equals(NotAValue.NOT_A_VALUE);
    }

    private BigInteger getNumeric(ImmutableList<Value> list) {
        return ((Value)list.head).asNumeric();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.makeNameFragment() + this.initialSize + "," + this.stepSize + "," + this.maxSize + "," + this.terminator + ")";
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.initialSize, ((Until)obj).initialSize) && Objects.equals(this.stepSize, ((Until)obj).stepSize) && Objects.equals(this.maxSize, ((Until)obj).maxSize) && Objects.equals(this.terminator, ((Until)obj).terminator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.initialSize, this.stepSize, this.maxSize, this.terminator);
    }
}

