/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseGraph;
import io.parsingdata.metal.data.ParseItem;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.token.Token;
import java.util.Objects;
import java.util.Optional;

public class TokenRef
extends Token {
    private static final Token LOOKUP_FAILED = new Token("LOOKUP_FAILED", null){

        @Override
        protected Optional<ParseState> parseImpl(Environment environment) {
            return Util.failure();
        }
    };
    public final String referenceName;

    public TokenRef(String name, String referenceName, Encoding encoding) {
        super(name, encoding);
        this.referenceName = Util.checkNotNull(referenceName, "referenceName");
        if (referenceName.isEmpty()) {
            throw new IllegalArgumentException("Argument referenceName may not be empty.");
        }
    }

    @Override
    protected Optional<ParseState> parseImpl(Environment environment) {
        return this.lookup(ImmutableList.create(environment.parseState.order), this.referenceName).computeResult().parse(environment);
    }

    private Trampoline<Token> lookup(ImmutableList<ParseItem> items, String referenceName) {
        if (items.isEmpty()) {
            return Trampoline.complete(() -> LOOKUP_FAILED);
        }
        ParseItem item = (ParseItem)items.head;
        if (item.getDefinition().name.equals(referenceName)) {
            return Trampoline.complete(item::getDefinition);
        }
        if (item.isGraph() && !item.asGraph().isEmpty()) {
            return Trampoline.intermediate(() -> this.lookup(items.tail.add(item.asGraph().tail).add((ParseGraph)item.asGraph().head), referenceName));
        }
        return Trampoline.intermediate(() -> this.lookup(items.tail, referenceName));
    }

    @Override
    public Token getCanonical(ParseState parseState) {
        return this.lookup(ImmutableList.create(parseState.order), this.referenceName).computeResult();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.makeNameFragment() + this.referenceName + ")";
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.referenceName, ((TokenRef)obj).referenceName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.referenceName);
    }
}

