/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.callback.Callbacks;
import io.parsingdata.metal.encoding.Encoding;
import java.util.Objects;
import java.util.Optional;

public abstract class Token {
    public static final String NO_NAME = "";
    public static final String SEPARATOR = ".";
    public static final String EMPTY_NAME = "__EMPTY__";
    public final String name;
    public final Encoding encoding;

    protected Token(String name, Encoding encoding) {
        this.name = Util.checkNotNull(name, "name");
        this.encoding = encoding;
    }

    public Optional<ParseState> parse(Environment environment) {
        Environment activeEnvironment = this.encoding != null ? environment.withEncoding(this.encoding) : environment;
        Optional<ParseState> result = this.parseImpl(activeEnvironment.extendScope(this.name));
        environment.callbacks.handle(this, result.map(after -> Callbacks.success(this, environment.parseState, after)).orElseGet(() -> Callbacks.failure(this, environment.parseState)));
        return result;
    }

    protected abstract Optional<ParseState> parseImpl(Environment var1);

    public boolean isScopeDelimiter() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isIterable() {
        return false;
    }

    public Token getCanonical(ParseState parseState) {
        return this;
    }

    protected String makeNameFragment() {
        return this.name.isEmpty() ? NO_NAME : this.name + ",";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.name, ((Token)obj).name) && Objects.equals(this.encoding, ((Token)obj).encoding);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name, this.encoding);
    }
}

