/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.DataExpressionSource;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import io.parsingdata.metal.token.Token;
import java.util.Objects;
import java.util.Optional;

public class Tie
extends Token {
    public final Token token;
    public final ValueExpression dataExpression;

    public Tie(String name, Token token, ValueExpression dataExpression, Encoding encoding) {
        super(name, encoding);
        this.token = Util.checkNotNull(token, "token");
        this.dataExpression = Util.checkNotNull(dataExpression, "dataExpression");
    }

    @Override
    protected Optional<ParseState> parseImpl(Environment environment) {
        return this.iterate(environment.addBranch(this), this.dataExpression.eval(environment.parseState, environment.encoding), 0, environment.parseState).computeResult();
    }

    private Trampoline<Optional<ParseState>> iterate(Environment environment, ImmutableList<Value> values, int index, ParseState returnParseState) {
        if (values.isEmpty()) {
            return Trampoline.complete(() -> Util.success(new ParseState(environment.parseState.closeBranch((Token)this).order, returnParseState.source, returnParseState.offset, returnParseState.iterations)));
        }
        if (((Value)values.head).equals(NotAValue.NOT_A_VALUE)) {
            return Trampoline.complete(Util::failure);
        }
        return this.token.parse(environment.withParseState(environment.parseState.withSource(new DataExpressionSource(this.dataExpression, index, environment.parseState, environment.encoding)))).map(nextParseState -> Trampoline.intermediate(() -> this.iterate(environment.withParseState((ParseState)nextParseState), values.tail, index + 1, returnParseState))).orElseGet(() -> Trampoline.complete(Util::failure));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.makeNameFragment() + this.token + "," + this.dataExpression + ")";
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.token, ((Tie)obj).token) && Objects.equals(this.dataExpression, ((Tie)obj).dataExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.token, this.dataExpression);
    }
}

