/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseReference;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.Selection;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import io.parsingdata.metal.token.Token;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class Sub
extends Token {
    public final Token token;
    public final ValueExpression offsets;

    public Sub(String name, Token token, ValueExpression offsets, Encoding encoding) {
        super(name, encoding);
        this.token = Util.checkNotNull(token, "token");
        this.offsets = Util.checkNotNull(offsets, "offsets");
    }

    @Override
    protected Optional<ParseState> parseImpl(Environment environment) {
        return this.iterate(environment.addBranch(this), this.offsets.eval(environment.parseState, environment.encoding)).computeResult().flatMap(nextParseState -> nextParseState.seek(environment.parseState.offset));
    }

    private Trampoline<Optional<ParseState>> iterate(Environment environment, ImmutableList<Value> offsetList) {
        if (offsetList.isEmpty()) {
            return Trampoline.complete(() -> Util.success(environment.parseState.closeBranch(this)));
        }
        if (((Value)offsetList.head).equals(NotAValue.NOT_A_VALUE)) {
            return Trampoline.complete(Util::failure);
        }
        return this.parse(environment, ((Value)offsetList.head).asNumeric()).map(nextParseState -> Trampoline.intermediate(() -> this.iterate(environment.withParseState((ParseState)nextParseState), offsetList.tail))).orElseGet(() -> Trampoline.complete(Util::failure));
    }

    private Optional<ParseState> parse(Environment environment, BigInteger offsetValue) {
        if (Selection.hasRootAtOffset(environment.parseState.order, this.token.getCanonical(environment.parseState), offsetValue, environment.parseState.source)) {
            return Util.success(environment.parseState.add(new ParseReference(offsetValue, environment.parseState.source, this.token.getCanonical(environment.parseState))));
        }
        return environment.parseState.seek(offsetValue).map(newParseState -> this.token.parse(environment.withParseState((ParseState)newParseState))).orElseGet(Util::failure);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.makeNameFragment() + this.token + "," + this.offsets + ")";
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.token, ((Sub)obj).token) && Objects.equals(this.offsets, ((Sub)obj).offsets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.token, this.offsets);
    }
}

