/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.token.Token;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class IterableToken
extends Token {
    public final Token token;

    IterableToken(String name, Token token, Encoding encoding) {
        super(name, encoding);
        this.token = Util.checkNotNull(token, "token");
    }

    protected final Optional<ParseState> parse(Environment environment, Predicate<Environment> stopCondition, Function<Environment, Optional<ParseState>> ifIterationFails) {
        return this.iterate(environment.addBranch(this), stopCondition, ifIterationFails).computeResult();
    }

    private Trampoline<Optional<ParseState>> iterate(Environment environment, Predicate<Environment> stopCondition, Function<Environment, Optional<ParseState>> ifIterationFails) {
        if (stopCondition.test(environment)) {
            return Trampoline.complete(() -> Util.success(environment.parseState.closeBranch(this)));
        }
        return this.token.parse(environment).map(nextParseState -> Trampoline.intermediate(() -> this.iterate(environment.withParseState(nextParseState.iterate()), stopCondition, ifIterationFails))).orElseGet(() -> Trampoline.complete(() -> (Optional)ifIterationFails.apply(environment)));
    }

    @Override
    public boolean isScopeDelimiter() {
        return true;
    }

    @Override
    public boolean isIterable() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.token, ((IterableToken)obj).token);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.token);
    }
}

