/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.token;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.ParseValue;
import io.parsingdata.metal.data.Slice;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.SingleValueExpression;
import io.parsingdata.metal.token.Token;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class Def
extends Token {
    public final SingleValueExpression size;

    public Def(String name, SingleValueExpression size, Encoding encoding) {
        super(Util.checkNotEmpty(name, "name"), encoding);
        this.size = Util.checkNotNull(size, "size");
    }

    @Override
    protected Optional<ParseState> parseImpl(Environment environment) {
        return this.size.evalSingle(environment.parseState, environment.encoding).filter(sizeValue -> !sizeValue.equals(NotAValue.NOT_A_VALUE)).flatMap(sizeValue -> sizeValue.asNumeric().compareTo(BigInteger.ZERO) != 0 ? this.slice(environment, sizeValue.asNumeric()) : Util.success(environment.parseState));
    }

    private Optional<ParseState> slice(Environment environment, BigInteger dataSize) {
        return environment.parseState.slice(dataSize).flatMap(slice -> environment.parseState.add(new ParseValue(environment.scope, this, (Slice)slice, environment.encoding)).seek(dataSize.add(environment.parseState.offset)));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.makeNameFragment() + this.size + ")";
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.size, ((Def)obj).size);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.size);
    }
}

