/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value.reference;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.ParseValue;
import io.parsingdata.metal.data.Selection;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import io.parsingdata.metal.token.Token;
import java.util.Objects;
import java.util.function.Predicate;

public class Ref<T>
implements ValueExpression {
    public final T reference;
    public final Predicate<ParseValue> predicate;
    public final ValueExpression limit;

    private Ref(T reference, Predicate<ParseValue> predicate, ValueExpression limit) {
        this.reference = Util.checkNotNull(reference, "reference");
        this.predicate = Util.checkNotNull(predicate, "predicate");
        this.limit = limit;
    }

    @Override
    public ImmutableList<Value> eval(ParseState parseState, Encoding encoding) {
        if (this.limit == null) {
            return this.evalImpl(parseState, -1);
        }
        ImmutableList<Value> evaluatedLimit = this.limit.eval(parseState, encoding);
        if (evaluatedLimit.size != 1L) {
            throw new IllegalArgumentException("Limit must evaluate to a single non-empty value.");
        }
        if (((Value)evaluatedLimit.head).equals(NotAValue.NOT_A_VALUE)) {
            return ImmutableList.create(NotAValue.NOT_A_VALUE);
        }
        return this.evalImpl(parseState, ((Value)evaluatedLimit.head).asNumeric().intValueExact());
    }

    private ImmutableList<Value> evalImpl(ParseState parseState, int limit) {
        return Ref.wrap(Selection.getAllValues(parseState.order, this.predicate, limit), new ImmutableList()).computeResult();
    }

    private static <T, U extends T> Trampoline<ImmutableList<T>> wrap(ImmutableList<U> input, ImmutableList<T> output) {
        if (input.isEmpty()) {
            return Trampoline.complete(() -> output);
        }
        return Trampoline.intermediate(() -> Ref.wrap(input.tail, output.add(input.head)));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.reference + (this.limit == null ? "" : "," + this.limit) + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.reference, ((Ref)obj).reference) && Objects.equals(this.limit, ((Ref)obj).limit);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.reference, this.limit);
    }

    public static class DefinitionRef
    extends Ref<Token> {
        public DefinitionRef(Token reference) {
            this(reference, null);
        }

        public DefinitionRef(Token reference, ValueExpression limit) {
            super(reference, value -> value.definition.equals(reference), limit);
        }
    }

    public static class NameRef
    extends Ref<String> {
        public NameRef(String reference) {
            this(reference, null);
        }

        public NameRef(String reference, ValueExpression limit) {
            super(reference, value -> value.matches(reference), limit);
        }
    }
}

