/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value.reference;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.Selection;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.math.BigInteger;
import java.util.Objects;

public class Nth
implements ValueExpression {
    public final ValueExpression values;
    public final ValueExpression indices;

    public Nth(ValueExpression values, ValueExpression indices) {
        this.values = Util.checkNotNull(values, "values");
        this.indices = Util.checkNotNull(indices, "indices");
    }

    @Override
    public ImmutableList<Value> eval(ParseState parseState, Encoding encoding) {
        return Selection.reverse(this.eval(this.values.eval(parseState, encoding), this.indices.eval(parseState, encoding), new ImmutableList<Value>()).computeResult());
    }

    private Trampoline<ImmutableList<Value>> eval(ImmutableList<Value> values, ImmutableList<Value> indices, ImmutableList<Value> result) {
        if (indices.isEmpty()) {
            return Trampoline.complete(() -> result);
        }
        BigInteger valueCount = BigInteger.valueOf(values.size);
        Value index = (Value)indices.head;
        Value nextResult = !index.equals(NotAValue.NOT_A_VALUE) && index.asNumeric().compareTo(valueCount) < 0 && index.asNumeric().compareTo(BigInteger.ZERO) >= 0 ? this.nth(values, valueCount.subtract(index.asNumeric()).subtract(BigInteger.ONE)).computeResult() : NotAValue.NOT_A_VALUE;
        return Trampoline.intermediate(() -> this.eval(values, indices.tail, result.add(nextResult)));
    }

    private Trampoline<Value> nth(ImmutableList<Value> values, BigInteger index) {
        if (index.equals(BigInteger.ZERO)) {
            return Trampoline.complete(() -> (Value)values.head);
        }
        return Trampoline.intermediate(() -> this.nth(values.tail, index.subtract(BigInteger.ONE)));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.values + "," + this.indices + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.values, ((Nth)obj).values) && Objects.equals(this.indices, ((Nth)obj).indices);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.values, this.indices);
    }
}

