/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value.reference;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ImmutablePair;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.ConstantFactory;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.SingleValueExpression;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.token.Token;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class CurrentIteration
implements SingleValueExpression {
    private final SingleValueExpression level;

    public CurrentIteration(SingleValueExpression level) {
        this.level = Util.checkNotNull(level, "level");
    }

    @Override
    public Optional<Value> evalSingle(ParseState parseState, Encoding encoding) {
        Optional<Value> levelValue = this.level.evalSingle(parseState, encoding);
        if (!levelValue.isPresent() || levelValue.get().equals(NotAValue.NOT_A_VALUE) || levelValue.get().asNumeric().compareTo(BigInteger.ZERO) < 0) {
            return Optional.of(NotAValue.NOT_A_VALUE);
        }
        if (parseState.iterations.size <= levelValue.get().asNumeric().longValueExact()) {
            return Optional.empty();
        }
        return this.getIterationRecursive(parseState.iterations, levelValue.get().asNumeric()).computeResult();
    }

    private Trampoline<Optional<Value>> getIterationRecursive(ImmutableList<ImmutablePair<Token, BigInteger>> iterations, BigInteger levelValue) {
        if (levelValue.compareTo(BigInteger.ZERO) == 0) {
            return Trampoline.complete(() -> Optional.of(ConstantFactory.createFromNumeric((BigInteger)((ImmutablePair)iterations.head).right, Encoding.DEFAULT_ENCODING)));
        }
        return Trampoline.intermediate(() -> this.getIterationRecursive(iterations.tail, levelValue.subtract(BigInteger.ONE)));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.level, ((CurrentIteration)obj).level);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.level);
    }
}

