/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value.reference;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.encoding.Sign;
import io.parsingdata.metal.expression.value.ConstantFactory;
import io.parsingdata.metal.expression.value.SingleValueExpression;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.util.Objects;
import java.util.Optional;

public class Count
implements SingleValueExpression {
    public final ValueExpression operand;

    public Count(ValueExpression operand) {
        this.operand = Util.checkNotNull(operand, "operand");
    }

    @Override
    public Optional<Value> evalSingle(ParseState parseState, Encoding encoding) {
        return Optional.of(Count.fromNumeric(this.operand.eval((ParseState)parseState, (Encoding)encoding).size));
    }

    private static Value fromNumeric(long length) {
        return ConstantFactory.createFromNumeric(length, new Encoding(Sign.SIGNED));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.operand + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.operand, ((Count)obj).operand);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.operand);
    }
}

