/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value.bitwise;

import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.BinaryValueExpression;
import io.parsingdata.metal.expression.value.ConstantFactory;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.util.BitSet;
import java.util.Optional;

public class ShiftLeft
extends BinaryValueExpression {
    public ShiftLeft(ValueExpression operand, ValueExpression positions) {
        super(operand, positions);
    }

    @Override
    public Optional<Value> eval(Value leftValue, Value rightValue, ParseState parseState, Encoding encoding) {
        BitSet leftBits = leftValue.asBitSet();
        int shiftLeft = rightValue.asNumeric().intValueExact();
        int bitCount = leftBits.length() + shiftLeft;
        BitSet out = new BitSet(bitCount);
        int i = leftBits.nextSetBit(0);
        while (i >= 0) {
            out.set(i + shiftLeft);
            i = leftBits.nextSetBit(i + 1);
        }
        int minSize = (bitCount + 7) / 8;
        return Optional.of(ConstantFactory.createFromBitSet(out, minSize, encoding));
    }
}

