/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value.arithmetic;

import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.BinaryValueExpression;
import io.parsingdata.metal.expression.value.ConstantFactory;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.math.BigInteger;
import java.util.Optional;

public class Mod
extends BinaryValueExpression {
    public Mod(ValueExpression left, ValueExpression right) {
        super(left, right);
    }

    @Override
    public Optional<Value> eval(Value leftValue, Value rightValue, ParseState parseState, Encoding encoding) {
        if (rightValue.asNumeric().compareTo(BigInteger.ZERO) <= 0) {
            return Optional.of(NotAValue.NOT_A_VALUE);
        }
        return Optional.of(ConstantFactory.createFromNumeric(leftValue.asNumeric().mod(rightValue.asNumeric()), encoding));
    }
}

