/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.Selection;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.util.Objects;
import java.util.Optional;

public abstract class UnaryValueExpression
implements ValueExpression {
    public final ValueExpression operand;

    public UnaryValueExpression(ValueExpression operand) {
        this.operand = Util.checkNotNull(operand, "operand");
    }

    @Override
    public ImmutableList<Value> eval(ParseState parseState, Encoding encoding) {
        return Selection.reverse(this.eval(this.operand.eval(parseState, encoding), parseState, encoding, new ImmutableList<Value>()).computeResult());
    }

    private Trampoline<ImmutableList<Value>> eval(ImmutableList<Value> values, ParseState parseState, Encoding encoding, ImmutableList<Value> result) {
        if (values.isEmpty()) {
            return Trampoline.complete(() -> result);
        }
        return Trampoline.intermediate(() -> this.eval(values.tail, parseState, encoding, result.add(this.safeEval((Value)values.head, parseState, encoding))));
    }

    public abstract Optional<Value> eval(Value var1, ParseState var2, Encoding var3);

    private Value safeEval(Value value, ParseState parseState, Encoding encoding) {
        if (value.equals(NotAValue.NOT_A_VALUE)) {
            return NotAValue.NOT_A_VALUE;
        }
        return this.eval(value, parseState, encoding).orElse(NotAValue.NOT_A_VALUE);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.operand + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.operand, ((UnaryValueExpression)obj).operand);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.operand);
    }
}

