/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseGraph;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.SingleValueExpression;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.math.BigInteger;
import java.util.Objects;

public class Scope
implements ValueExpression {
    public final ValueExpression scopedValueExpression;
    public final SingleValueExpression scopeSize;

    public Scope(ValueExpression scopedValueExpression, SingleValueExpression scopeSize) {
        this.scopedValueExpression = Util.checkNotNull(scopedValueExpression, "scopedValueExpression");
        this.scopeSize = Util.checkNotNull(scopeSize, "scopeSize");
    }

    @Override
    public ImmutableList<Value> eval(ParseState parseState, Encoding encoding) {
        return this.scopeSize.evalSingle(parseState, encoding).filter(sizeValue -> !sizeValue.equals(NotAValue.NOT_A_VALUE) && sizeValue.asNumeric().compareTo(BigInteger.ZERO) >= 0).map(sizeValue -> this.scopedValueExpression.eval(parseState.withOrder(this.calculateScope(parseState.order, sizeValue.asNumeric().intValueExact())), encoding)).orElseThrow(() -> new IllegalArgumentException("Argument scopeSize must evaluate to a positive, countable value."));
    }

    private ParseGraph calculateScope(ParseGraph order, int size) {
        ImmutableList<ParseGraph> scopeList = this.createScopeList(order, new ImmutableList<ParseGraph>()).computeResult();
        if ((long)size >= scopeList.size) {
            return order;
        }
        return this.findScope(scopeList, size).computeResult();
    }

    private Trampoline<ImmutableList<ParseGraph>> createScopeList(ParseGraph order, ImmutableList<ParseGraph> list) {
        ImmutableList<ParseGraph> newList;
        ImmutableList<ParseGraph> immutableList = newList = order.getDefinition().isScopeDelimiter() ? list.add(order) : list;
        if (order.isEmpty() || !order.head.isGraph()) {
            return Trampoline.complete(() -> list);
        }
        return Trampoline.intermediate(() -> this.createScopeList(order.head.asGraph(), newList));
    }

    private Trampoline<ParseGraph> findScope(ImmutableList<ParseGraph> scopeList, int size) {
        if (size == 0) {
            return Trampoline.complete(() -> (ParseGraph)scopeList.head);
        }
        return Trampoline.intermediate(() -> this.findScope(scopeList.tail, size - 1));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.scopedValueExpression + "," + this.scopeSize + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.scopedValueExpression, ((Scope)obj).scopedValueExpression) && Objects.equals(this.scopeSize, ((Scope)obj).scopeSize);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.scopedValueExpression, this.scopeSize);
    }
}

