/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ConcatenatedValueSource;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.Slice;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.CoreValue;
import io.parsingdata.metal.expression.value.SingleValueExpression;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class FoldCat
implements SingleValueExpression {
    public final ValueExpression operand;

    public FoldCat(ValueExpression operand) {
        this.operand = operand;
    }

    @Override
    public Optional<Value> evalSingle(ParseState parseState, Encoding encoding) {
        return ConcatenatedValueSource.create(this.operand.eval(parseState, encoding)).flatMap(source -> Slice.createFromSource(source, BigInteger.ZERO, source.length)).map(slice -> new CoreValue((Slice)slice, encoding));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.operand + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.operand, ((FoldCat)obj).operand);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.operand);
    }
}

