/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.SingleValueExpression;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;

public abstract class Fold
implements SingleValueExpression {
    public final ValueExpression values;
    public final BinaryOperator<ValueExpression> reducer;
    public final SingleValueExpression initial;

    public Fold(ValueExpression values, BinaryOperator<ValueExpression> reducer, SingleValueExpression initial) {
        this.values = Util.checkNotNull(values, "values");
        this.reducer = Util.checkNotNull(reducer, "reducer");
        this.initial = initial;
    }

    @Override
    public Optional<Value> evalSingle(ParseState parseState, Encoding encoding) {
        Optional<Value> initialValue;
        Optional<Value> optional = initialValue = this.initial != null ? this.initial.evalSingle(parseState, encoding) : Optional.empty();
        if (initialValue.isPresent() && ((Value)initialValue.get()).equals(NotAValue.NOT_A_VALUE)) {
            return initialValue;
        }
        ImmutableList<Value> unpreparedValues = this.values.eval(parseState, encoding);
        if (unpreparedValues.isEmpty()) {
            return initialValue;
        }
        if (this.containsNotAValue(unpreparedValues).computeResult().booleanValue()) {
            return Optional.of(NotAValue.NOT_A_VALUE);
        }
        ImmutableList valueList = initialValue.map(value -> this.prepareValues(unpreparedValues).add((Value)value)).orElseGet(() -> this.prepareValues(unpreparedValues));
        return Optional.of(this.fold(parseState, encoding, this.reducer, (Value)valueList.head, valueList.tail).computeResult());
    }

    private Trampoline<Value> fold(ParseState parseState, Encoding encoding, BinaryOperator<ValueExpression> reducer, Value head, ImmutableList<Value> tail) {
        if (head.equals(NotAValue.NOT_A_VALUE)) {
            return Trampoline.complete(() -> NotAValue.NOT_A_VALUE);
        }
        if (tail.isEmpty()) {
            return Trampoline.complete(() -> head);
        }
        ImmutableList<Value> reducedValue = this.reduce(reducer, head, (Value)tail.head).eval(parseState, encoding);
        if (reducedValue.size != 1L) {
            throw new IllegalArgumentException("Reducer must evaluate to a single value.");
        }
        return Trampoline.intermediate(() -> this.fold(parseState, encoding, reducer, (Value)reducedValue.head, tail.tail));
    }

    private Trampoline<Boolean> containsNotAValue(ImmutableList<Value> list) {
        if (list.isEmpty()) {
            return Trampoline.complete(() -> false);
        }
        if (((Value)list.head).equals(NotAValue.NOT_A_VALUE)) {
            return Trampoline.complete(() -> true);
        }
        return Trampoline.intermediate(() -> this.containsNotAValue(list.tail));
    }

    protected abstract ImmutableList<Value> prepareValues(ImmutableList<Value> var1);

    protected abstract ValueExpression reduce(BinaryOperator<ValueExpression> var1, Value var2, Value var3);

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.values + "," + this.reducer + (this.initial == null ? "" : "," + this.initial) + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.values, ((Fold)obj).values) && Objects.equals(this.reducer, ((Fold)obj).reducer) && Objects.equals(this.initial, ((Fold)obj).initial);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.values, this.reducer, this.initial);
    }
}

