/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.SingleValueExpression;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.util.Objects;

public class Expand
implements ValueExpression {
    public final ValueExpression bases;
    public final SingleValueExpression count;

    public Expand(ValueExpression bases, SingleValueExpression count) {
        this.bases = Util.checkNotNull(bases, "bases");
        this.count = Util.checkNotNull(count, "count");
    }

    @Override
    public ImmutableList<Value> eval(ParseState parseState, Encoding encoding) {
        ImmutableList<Value> baseList = this.bases.eval(parseState, encoding);
        if (baseList.isEmpty()) {
            return baseList;
        }
        return this.count.evalSingle(parseState, encoding).filter(countValue -> !countValue.equals(NotAValue.NOT_A_VALUE)).map(countValue -> this.expand(baseList, countValue.asNumeric().intValueExact(), new ImmutableList<Value>()).computeResult()).orElseThrow(() -> new IllegalArgumentException("Count must evaluate to a non-empty countable value."));
    }

    private Trampoline<ImmutableList<Value>> expand(ImmutableList<Value> baseList, int countValue, ImmutableList<Value> aggregate) {
        if (countValue < 1) {
            return Trampoline.complete(() -> aggregate);
        }
        return Trampoline.intermediate(() -> this.expand(baseList, countValue - 1, aggregate.add(baseList)));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.bases + "," + this.count + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.bases, ((Expand)obj).bases) && Objects.equals(this.count, ((Expand)obj).count);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.bases, this.count);
    }
}

