/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.Selection;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.util.Objects;

public class Elvis
implements ValueExpression {
    public final ValueExpression left;
    public final ValueExpression right;

    public Elvis(ValueExpression left, ValueExpression right) {
        this.left = Util.checkNotNull(left, "left");
        this.right = Util.checkNotNull(right, "right");
    }

    @Override
    public ImmutableList<Value> eval(ParseState parseState, Encoding encoding) {
        return Selection.reverse(this.eval(new ImmutableList<Value>(), this.left.eval(parseState, encoding), this.right.eval(parseState, encoding)).computeResult());
    }

    private Trampoline<ImmutableList<Value>> eval(ImmutableList<Value> result, ImmutableList<Value> leftValues, ImmutableList<Value> rightValues) {
        if (leftValues.isEmpty()) {
            return Trampoline.complete(() -> result.add(Selection.reverse(rightValues)));
        }
        if (rightValues.isEmpty()) {
            return Trampoline.complete(() -> result.add(Selection.reverse(leftValues)));
        }
        return Trampoline.intermediate(() -> this.eval(result.add(((Value)leftValues.head).equals(NotAValue.NOT_A_VALUE) ? (Value)rightValues.head : (Value)leftValues.head), leftValues.tail, rightValues.tail));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.left + "," + this.right + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.left, ((Elvis)obj).left) && Objects.equals(this.right, ((Elvis)obj).right);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.left, this.right);
    }
}

