/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Slice;
import io.parsingdata.metal.encoding.ByteOrder;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.encoding.Sign;
import io.parsingdata.metal.expression.value.Value;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Objects;

public class CoreValue
implements Value {
    public static final BigInteger TO_STRING_BYTE_COUNT = BigInteger.valueOf(4L);
    private final Slice slice;
    private final Encoding encoding;

    public CoreValue(Slice slice, Encoding encoding) {
        this.slice = Util.checkNotNull(slice, "slice");
        this.encoding = Util.checkNotNull(encoding, "encoding");
    }

    @Override
    public Slice slice() {
        return this.slice;
    }

    @Override
    public Encoding encoding() {
        return this.encoding;
    }

    @Override
    public byte[] value() {
        return this.slice.getData();
    }

    @Override
    public BigInteger length() {
        return this.slice.length;
    }

    @Override
    public BigInteger asNumeric() {
        return this.encoding.sign == Sign.SIGNED ? new BigInteger(this.encoding.byteOrder.apply(this.value())) : new BigInteger(1, this.encoding.byteOrder.apply(this.value()));
    }

    @Override
    public String asString() {
        return new String(this.value(), this.encoding.charset);
    }

    @Override
    public BitSet asBitSet() {
        return BitSet.valueOf(this.encoding.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN.apply(this.value()) : this.value());
    }

    public String toString() {
        return "0x" + Util.bytesToHexString(this.slice.getData(TO_STRING_BYTE_COUNT)) + (this.length().compareTo(TO_STRING_BYTE_COUNT) > 0 ? "..." : "");
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.slice, ((CoreValue)obj).slice) && Objects.equals(this.encoding, ((CoreValue)obj).encoding);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.slice, this.encoding);
    }
}

