/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.data.Slice;
import io.parsingdata.metal.encoding.ByteOrder;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.encoding.Sign;
import io.parsingdata.metal.expression.value.CoreValue;
import io.parsingdata.metal.expression.value.Value;
import java.math.BigInteger;
import java.util.BitSet;

public final class ConstantFactory {
    private ConstantFactory() {
    }

    public static Value createFromBytes(byte[] value, Encoding encoding) {
        return new CoreValue(Slice.createFromBytes(value), encoding);
    }

    public static Value createFromNumeric(BigInteger value, Encoding encoding) {
        return ConstantFactory.createFromBytes(ConstantFactory.compact(value.toByteArray(), encoding.sign == Sign.SIGNED), ConstantFactory.setToBigEndian(encoding));
    }

    public static Value createFromNumeric(long value, Encoding encoding) {
        return ConstantFactory.createFromNumeric(BigInteger.valueOf(value), encoding);
    }

    public static Value createFromString(String value, Encoding encoding) {
        return new CoreValue(Slice.createFromBytes(value.getBytes(encoding.charset)), encoding);
    }

    public static Value createFromBitSet(BitSet value, int minSize, Encoding encoding) {
        byte[] bytes = ByteOrder.LITTLE_ENDIAN.apply(value.toByteArray());
        byte[] outBytes = new byte[Math.max(minSize, bytes.length)];
        System.arraycopy(bytes, 0, outBytes, outBytes.length - bytes.length, bytes.length);
        return new CoreValue(Slice.createFromBytes(outBytes), ConstantFactory.setToBigEndian(encoding));
    }

    private static Encoding setToBigEndian(Encoding encoding) {
        return new Encoding(encoding.sign, encoding.charset, ByteOrder.BIG_ENDIAN);
    }

    private static byte[] compact(byte[] data, boolean signed) {
        if (signed || data.length < 2) {
            return data;
        }
        if (data[0] == 0) {
            byte[] outBytes = new byte[data.length - 1];
            System.arraycopy(data, 1, outBytes, 0, outBytes.length);
            return outBytes;
        }
        return data;
    }
}

