/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.Slice;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.CoreValue;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.math.BigInteger;
import java.util.Objects;

public class Bytes
implements ValueExpression {
    public final ValueExpression operand;

    public Bytes(ValueExpression operand) {
        this.operand = Util.checkNotNull(operand, "operand");
    }

    @Override
    public ImmutableList<Value> eval(ParseState parseState, Encoding encoding) {
        ImmutableList<Value> values = this.operand.eval(parseState, encoding);
        return values.isEmpty() ? values : this.toByteValues(new ImmutableList<Value>(), (Value)values.head, values.tail, encoding).computeResult();
    }

    private Trampoline<ImmutableList<Value>> toByteValues(ImmutableList<Value> output, Value head, ImmutableList<Value> tail, Encoding encoding) {
        ImmutableList<Value> result = output.add(this.extractByteValues(new ImmutableList<Value>(), head, 0, encoding).computeResult());
        if (tail.isEmpty()) {
            return Trampoline.complete(() -> result);
        }
        return Trampoline.intermediate(() -> this.toByteValues(result, (Value)tail.head, tail.tail, encoding));
    }

    private Trampoline<ImmutableList<Value>> extractByteValues(ImmutableList<Value> output, Value value, int i, Encoding encoding) {
        if (value.equals(NotAValue.NOT_A_VALUE) || BigInteger.valueOf(i).compareTo(value.length()) >= 0) {
            return Trampoline.complete(() -> output);
        }
        return Trampoline.intermediate(() -> this.extractByteValues(output.add(new CoreValue(Slice.createFromSource(value.slice().source, value.slice().offset.add(BigInteger.valueOf(i)), BigInteger.ONE).get(), encoding)), value, i + 1, encoding));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.operand + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.operand, ((Bytes)obj).operand);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.operand);
    }
}

