/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.value;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.Selection;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.util.Objects;
import java.util.Optional;

public abstract class BinaryValueExpression
implements ValueExpression {
    public final ValueExpression left;
    public final ValueExpression right;

    public BinaryValueExpression(ValueExpression left, ValueExpression right) {
        this.left = Util.checkNotNull(left, "left");
        this.right = Util.checkNotNull(right, "right");
    }

    public abstract Optional<Value> eval(Value var1, Value var2, ParseState var3, Encoding var4);

    @Override
    public ImmutableList<Value> eval(ParseState parseState, Encoding encoding) {
        return this.evalLists(this.left.eval(parseState, encoding), this.right.eval(parseState, encoding), parseState, encoding);
    }

    private ImmutableList<Value> evalLists(ImmutableList<Value> leftValues, ImmutableList<Value> rightValues, ParseState parseState, Encoding encoding) {
        return Selection.reverse(this.padList(this.evalLists(leftValues, rightValues, parseState, encoding, new ImmutableList<Value>()).computeResult(), Math.abs(leftValues.size - rightValues.size)).computeResult());
    }

    private Trampoline<ImmutableList<Value>> evalLists(ImmutableList<Value> leftValues, ImmutableList<Value> rightValues, ParseState parseState, Encoding encoding, ImmutableList<Value> result) {
        if (leftValues.isEmpty() || rightValues.isEmpty()) {
            return Trampoline.complete(() -> result);
        }
        return Trampoline.intermediate(() -> this.evalLists(leftValues.tail, rightValues.tail, parseState, encoding, result.add(this.safeEval((Value)leftValues.head, (Value)rightValues.head, parseState, encoding))));
    }

    private Trampoline<ImmutableList<Value>> padList(ImmutableList<Value> list, long size) {
        if (size <= 0L) {
            return Trampoline.complete(() -> list);
        }
        return Trampoline.intermediate(() -> this.padList(list.add(NotAValue.NOT_A_VALUE), size - 1L));
    }

    private Value safeEval(Value leftValue, Value rightValue, ParseState parseState, Encoding encoding) {
        if (leftValue.equals(NotAValue.NOT_A_VALUE) || rightValue.equals(NotAValue.NOT_A_VALUE)) {
            return NotAValue.NOT_A_VALUE;
        }
        return this.eval(leftValue, rightValue, parseState, encoding).orElse(NotAValue.NOT_A_VALUE);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.left + "," + this.right + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.left, ((BinaryValueExpression)obj).left) && Objects.equals(this.right, ((BinaryValueExpression)obj).right);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.left, this.right);
    }
}

