/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.expression.comparison;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.Expression;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.util.Objects;

public abstract class ComparisonExpression
implements Expression {
    public final ValueExpression value;
    public final ValueExpression predicate;

    public ComparisonExpression(ValueExpression value, ValueExpression predicate) {
        this.value = value;
        this.predicate = Util.checkNotNull(predicate, "predicate");
    }

    @Override
    public boolean eval(ParseState parseState, Encoding encoding) {
        ImmutableList values;
        ImmutableList immutableList = values = this.value == null ? parseState.order.current().map(ImmutableList::create).orElseGet(ImmutableList::new) : this.value.eval(parseState, encoding);
        if (values.isEmpty()) {
            return false;
        }
        ImmutableList<Value> predicates = this.predicate.eval(parseState, encoding);
        if (values.size != predicates.size) {
            return false;
        }
        return this.compare(values, predicates).computeResult();
    }

    private Trampoline<Boolean> compare(ImmutableList<Value> currents, ImmutableList<Value> predicates) {
        if (((Value)currents.head).equals(NotAValue.NOT_A_VALUE) || ((Value)predicates.head).equals(NotAValue.NOT_A_VALUE)) {
            return Trampoline.complete(() -> false);
        }
        boolean headResult = this.compare((Value)currents.head, (Value)predicates.head);
        if (!headResult || currents.tail.isEmpty()) {
            return Trampoline.complete(() -> headResult);
        }
        return Trampoline.intermediate(() -> this.compare(currents.tail, predicates.tail));
    }

    public abstract boolean compare(Value var1, Value var2);

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this.value == null ? "" : this.value + ",") + this.predicate + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.value, ((ComparisonExpression)obj).value) && Objects.equals(this.predicate, ((ComparisonExpression)obj).predicate);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.value, this.predicate);
    }
}

