/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.encoding;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.encoding.ByteOrder;
import io.parsingdata.metal.encoding.Sign;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class Encoding {
    public static final Sign DEFAULT_SIGN = Sign.UNSIGNED;
    public static final Charset DEFAULT_CHARSET = StandardCharsets.US_ASCII;
    public static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    public static final Encoding DEFAULT_ENCODING = new Encoding(DEFAULT_SIGN, DEFAULT_CHARSET, DEFAULT_BYTE_ORDER);
    public final Sign sign;
    public final Charset charset;
    public final ByteOrder byteOrder;

    public Encoding(Sign signed) {
        this(signed, DEFAULT_CHARSET, DEFAULT_BYTE_ORDER);
    }

    public Encoding(Charset charset) {
        this(DEFAULT_SIGN, charset, DEFAULT_BYTE_ORDER);
    }

    public Encoding(ByteOrder byteOrder) {
        this(DEFAULT_SIGN, DEFAULT_CHARSET, byteOrder);
    }

    public Encoding(Sign sign, Charset charset, ByteOrder byteOrder) {
        this.sign = Util.checkNotNull(sign, "sign");
        this.charset = Util.checkNotNull(charset, "charset");
        this.byteOrder = Util.checkNotNull(byteOrder, "byteOrder");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (Object)((Object)this.sign) + "," + this.charset + "," + (Object)((Object)this.byteOrder) + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals((Object)this.sign, (Object)((Encoding)obj).sign) && Objects.equals(this.charset, ((Encoding)obj).charset) && Objects.equals((Object)this.byteOrder, (Object)((Encoding)obj).byteOrder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.sign, this.charset, this.byteOrder});
    }
}

