/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data.callback;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ImmutablePair;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.callback.Callback;
import io.parsingdata.metal.token.Token;
import java.util.function.Consumer;

public class Callbacks {
    public static final Callbacks NONE = new Callbacks(null, new ImmutableList<ImmutablePair<Token, Callback>>());
    public final Callback genericCallback;
    public final ImmutableList<ImmutablePair<Token, Callback>> tokenCallbacks;

    private Callbacks(Callback genericCallback, ImmutableList<ImmutablePair<Token, Callback>> tokenCallbacks) {
        this.genericCallback = genericCallback;
        this.tokenCallbacks = Util.checkNotNull(tokenCallbacks, "tokenCallbacks");
    }

    public static Callbacks create() {
        return NONE;
    }

    public Callbacks add(Callback genericCallback) {
        return new Callbacks(genericCallback, this.tokenCallbacks);
    }

    public Callbacks add(Token token, Callback callback) {
        return new Callbacks(this.genericCallback, this.tokenCallbacks.add(new ImmutablePair<Token, Callback>(token, callback)));
    }

    public static Consumer<Callback> success(Token token, ParseState before, ParseState after) {
        return callback -> callback.handleSuccess(token, before, after);
    }

    public static Consumer<Callback> failure(Token token, ParseState before) {
        return callback -> callback.handleFailure(token, before);
    }

    public void handle(Token token, Consumer<Callback> handler) {
        if (this.genericCallback != null) {
            handler.accept(this.genericCallback);
        }
        this.handleCallbacks(this.tokenCallbacks, token, handler).computeResult();
    }

    private Trampoline<Void> handleCallbacks(ImmutableList<ImmutablePair<Token, Callback>> callbacks, Token token, Consumer<Callback> handler) {
        if (callbacks.isEmpty()) {
            return Trampoline.complete(() -> null);
        }
        if (((Token)((ImmutablePair)callbacks.head).left).equals(token)) {
            handler.accept((Callback)((ImmutablePair)callbacks.head).right);
        }
        return Trampoline.intermediate(() -> this.handleCallbacks(callbacks.tail, token, handler));
    }

    public String toString() {
        return (this.genericCallback == null ? "" : "generic: " + this.genericCallback + "; ") + (this.tokenCallbacks.isEmpty() ? "" : "token: " + this.tokenCallbacks);
    }
}

