/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ConstantSource;
import io.parsingdata.metal.data.Source;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class Slice {
    public final Source source;
    public final BigInteger offset;
    public final BigInteger length;

    private Slice(Source source, BigInteger offset, BigInteger length) {
        this.source = Util.checkNotNull(source, "source");
        this.offset = Util.checkNotNull(offset, "offset");
        this.length = Util.checkNotNull(length, "length");
    }

    public static Optional<Slice> createFromSource(Source source, BigInteger offset, BigInteger length) {
        if (Util.checkNotNull(offset, "offset").compareTo(BigInteger.ZERO) < 0 || Util.checkNotNull(length, "length").compareTo(BigInteger.ZERO) < 0 || !Util.checkNotNull(source, "source").isAvailable(offset, length)) {
            return Optional.empty();
        }
        return Optional.of(new Slice(source, offset, length));
    }

    public static Slice createFromBytes(byte[] data) {
        return new Slice(new ConstantSource(Util.checkNotNull(data, "data")), BigInteger.ZERO, BigInteger.valueOf(data.length));
    }

    public byte[] getData() {
        return this.getData(this.length);
    }

    public byte[] getData(BigInteger limit) {
        BigInteger calculatedLength = Util.checkNotNegative(limit, "limit").compareTo(this.length) > 0 ? this.length : limit;
        return this.source.getData(this.offset, calculatedLength);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.source + "@" + this.offset + ":" + this.length.add(this.offset) + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.source, ((Slice)obj).source) && Objects.equals(this.offset, ((Slice)obj).offset) && Objects.equals(this.length, ((Slice)obj).length);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.source, this.offset, this.length);
    }
}

