/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseGraph;
import io.parsingdata.metal.data.ParseItem;
import io.parsingdata.metal.data.ParseValue;
import io.parsingdata.metal.data.Source;
import io.parsingdata.metal.token.Token;
import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Predicate;

public final class Selection {
    public static final int NO_LIMIT = -1;

    private Selection() {
    }

    public static boolean hasRootAtOffset(ParseGraph graph, Token definition, BigInteger offset, Source source) {
        return Selection.findItemAtOffset(Selection.getAllRoots(graph, definition), offset, source).computeResult().isPresent();
    }

    public static Trampoline<Optional<ParseItem>> findItemAtOffset(ImmutableList<ParseItem> items, BigInteger offset, Source source) {
        ParseValue value;
        Util.checkNotNull(items, "items");
        Util.checkNotNull(source, "source");
        if (items.isEmpty()) {
            return Trampoline.complete(Optional::empty);
        }
        ParseItem head = (ParseItem)items.head;
        if (head.isValue() && Selection.matchesLocation(head.asValue(), offset, source)) {
            return Trampoline.complete(() -> Optional.of(head));
        }
        if (head.isGraph() && (value = Selection.getLowestOffsetValue(ImmutableList.create(head.asGraph()), null).computeResult()) != null && Selection.matchesLocation(value, offset, source)) {
            return Trampoline.complete(() -> Optional.of(head));
        }
        return Trampoline.intermediate(() -> Selection.findItemAtOffset(items.tail, offset, source));
    }

    private static boolean matchesLocation(ParseValue value, BigInteger offset, Source source) {
        return value.slice().offset.compareTo(offset) == 0 && value.slice().source.equals(source);
    }

    private static Trampoline<ParseValue> getLowestOffsetValue(ImmutableList<ParseGraph> graphList, ParseValue lowest) {
        if (graphList.isEmpty()) {
            return Trampoline.complete(() -> lowest);
        }
        ParseGraph graph = (ParseGraph)graphList.head;
        if (graph.isEmpty() || !graph.getDefinition().isLocal()) {
            return Trampoline.intermediate(() -> Selection.getLowestOffsetValue(graphList.tail, lowest));
        }
        return Trampoline.intermediate(() -> Selection.getLowestOffsetValue(Selection.addIfGraph(graphList.tail.add(graph.tail), graph.head), Selection.compareIfValue(lowest, graph.head)));
    }

    private static ParseValue compareIfValue(ParseValue lowest, ParseItem head) {
        return head.isValue() ? Selection.getLowest(lowest, head.asValue()) : lowest;
    }

    private static ParseValue getLowest(ParseValue lowest, ParseValue value) {
        return lowest == null || lowest.slice().offset.compareTo(value.slice().offset) > 0 ? value : lowest;
    }

    private static ImmutableList<ParseGraph> addIfGraph(ImmutableList<ParseGraph> graphList, ParseItem head) {
        return head.isGraph() ? graphList.add(head.asGraph()) : graphList;
    }

    public static ImmutableList<ParseValue> getAllValues(ParseGraph graph, Predicate<ParseValue> predicate, int limit) {
        return Selection.getAllValues(ImmutableList.create(graph), new ImmutableList<ParseValue>(), predicate, limit).computeResult();
    }

    public static ImmutableList<ParseValue> getAllValues(ParseGraph graph, Predicate<ParseValue> predicate) {
        return Selection.getAllValues(graph, predicate, -1);
    }

    private static Trampoline<ImmutableList<ParseValue>> getAllValues(ImmutableList<ParseGraph> graphList, ImmutableList<ParseValue> valueList, Predicate<ParseValue> predicate, int limit) {
        if (graphList.isEmpty() || valueList.size == (long)limit) {
            return Trampoline.complete(() -> valueList);
        }
        ParseGraph graph = (ParseGraph)graphList.head;
        if (graph.isEmpty()) {
            return Trampoline.intermediate(() -> Selection.getAllValues(graphList.tail, valueList, predicate, limit));
        }
        return Trampoline.intermediate(() -> Selection.getAllValues(Selection.addIfGraph(graphList.tail.add(graph.tail), graph.head), Selection.addIfMatchingValue(valueList, graph.head, predicate), predicate, limit));
    }

    private static ImmutableList<ParseValue> addIfMatchingValue(ImmutableList<ParseValue> valueList, ParseItem item, Predicate<ParseValue> predicate) {
        if (item.isValue() && predicate.test(item.asValue())) {
            return valueList.add(item.asValue());
        }
        return valueList;
    }

    public static <T> ImmutableList<T> reverse(ImmutableList<T> list) {
        if (list.isEmpty()) {
            return list;
        }
        return Selection.reverse(list.tail, ImmutableList.create(list.head)).computeResult();
    }

    private static <T> Trampoline<ImmutableList<T>> reverse(ImmutableList<T> oldList, ImmutableList<T> newList) {
        if (oldList.isEmpty()) {
            return Trampoline.complete(() -> newList);
        }
        return Trampoline.intermediate(() -> Selection.reverse(oldList.tail, newList.add(oldList.head)));
    }

    public static ImmutableList<ParseItem> getAllRoots(ParseGraph graph, Token definition) {
        return Selection.getAllRootsRecursive(ImmutableList.create(new Pair(Util.checkNotNull(graph, "graph"), null)), Util.checkNotNull(definition, "definition"), new ImmutableList<ParseItem>()).computeResult();
    }

    private static Trampoline<ImmutableList<ParseItem>> getAllRootsRecursive(ImmutableList<Pair> backlog, Token definition, ImmutableList<ParseItem> rootList) {
        ImmutableList<ParseItem> nextResult;
        if (backlog.isEmpty()) {
            return Trampoline.complete(() -> rootList);
        }
        ParseItem item = ((Pair)backlog.head).item;
        ParseGraph parent = ((Pair)backlog.head).parent;
        ImmutableList<ParseItem> immutableList = nextResult = item.getDefinition().equals(definition) && (parent == null || !parent.getDefinition().equals(definition)) ? rootList.add(item) : rootList;
        if (item.isGraph() && !item.asGraph().isEmpty()) {
            ParseGraph itemGraph = item.asGraph();
            return Trampoline.intermediate(() -> Selection.getAllRootsRecursive(backlog.tail.add(new Pair(itemGraph.head, itemGraph)).add(new Pair(itemGraph.tail, itemGraph)), definition, nextResult));
        }
        return Trampoline.intermediate(() -> Selection.getAllRootsRecursive(backlog.tail, definition, nextResult));
    }

    static class Pair {
        public final ParseItem item;
        public final ParseGraph parent;

        Pair(ParseItem item, ParseGraph parent) {
            this.item = Util.checkNotNull(item, "item");
            this.parent = parent;
        }
    }
}

