/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ParseItem;
import io.parsingdata.metal.data.Slice;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.CoreValue;
import io.parsingdata.metal.token.Token;
import java.util.Objects;

public class ParseValue
extends CoreValue
implements ParseItem {
    public final String name;
    public final Token definition;

    public ParseValue(String name, Token definition, Slice slice, Encoding encoding) {
        super(slice, encoding);
        this.name = Util.checkNotEmpty(name, "name");
        this.definition = Util.checkNotNull(definition, "definition");
    }

    public boolean matches(String name) {
        return this.name.equals(name) || this.name.endsWith("." + name);
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public ParseValue asValue() {
        return this;
    }

    @Override
    public Token getDefinition() {
        return this.definition;
    }

    @Override
    public String toString() {
        return "pval(" + this.name + ":" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.name, ((ParseValue)obj).name) && Objects.equals(this.definition, ((ParseValue)obj).definition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.definition);
    }
}

