/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ByteStream;
import io.parsingdata.metal.data.ByteStreamSource;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ImmutablePair;
import io.parsingdata.metal.data.ParseGraph;
import io.parsingdata.metal.data.ParseReference;
import io.parsingdata.metal.data.ParseValue;
import io.parsingdata.metal.data.Slice;
import io.parsingdata.metal.data.Source;
import io.parsingdata.metal.token.Token;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class ParseState {
    public final ParseGraph order;
    public final BigInteger offset;
    public final Source source;
    public final ImmutableList<ImmutablePair<Token, BigInteger>> iterations;

    public ParseState(ParseGraph order, Source source, BigInteger offset, ImmutableList<ImmutablePair<Token, BigInteger>> iterations) {
        this.order = Util.checkNotNull(order, "order");
        this.source = Util.checkNotNull(source, "source");
        this.offset = Util.checkNotNegative(offset, "offset");
        this.iterations = Util.checkNotNull(iterations, "iterations");
    }

    public static ParseState createFromByteStream(ByteStream input, BigInteger offset) {
        return new ParseState(ParseGraph.EMPTY, new ByteStreamSource(input), offset, new ImmutableList<ImmutablePair<Token, BigInteger>>());
    }

    public static ParseState createFromByteStream(ByteStream input) {
        return ParseState.createFromByteStream(input, BigInteger.ZERO);
    }

    public ParseState addBranch(Token token) {
        return new ParseState(this.order.addBranch(token), this.source, this.offset, token.isIterable() ? this.iterations.add(new ImmutablePair<Token, BigInteger>(token, BigInteger.ZERO)) : this.iterations);
    }

    public ParseState closeBranch(Token token) {
        if (token.isIterable() && !((Token)((ImmutablePair)this.iterations.head).left).equals(token)) {
            throw new IllegalStateException(Util.format("Cannot close branch for iterable token %s. Current iteration state is for token %s.", token.name, ((Token)((ImmutablePair)this.iterations.head).left).name));
        }
        return new ParseState(this.order.closeBranch(), this.source, this.offset, token.isIterable() ? this.iterations.tail : this.iterations);
    }

    public ParseState add(ParseValue parseValue) {
        return new ParseState(this.order.add(parseValue), this.source, this.offset, this.iterations);
    }

    public ParseState add(ParseReference parseReference) {
        return new ParseState(this.order.add(parseReference), this.source, this.offset, this.iterations);
    }

    public ParseState iterate() {
        return new ParseState(this.order, this.source, this.offset, this.iterations.tail.add(new ImmutablePair<Token, BigInteger>((Token)((ImmutablePair)this.iterations.head).left, ((BigInteger)((ImmutablePair)this.iterations.head).right).add(BigInteger.ONE))));
    }

    public Optional<ParseState> seek(BigInteger newOffset) {
        return newOffset.compareTo(BigInteger.ZERO) >= 0 ? Optional.of(new ParseState(this.order, this.source, newOffset, this.iterations)) : Optional.empty();
    }

    public ParseState withOrder(ParseGraph order) {
        return new ParseState(order, this.source, this.offset, this.iterations);
    }

    public ParseState withSource(Source source) {
        return new ParseState(this.order, source, BigInteger.ZERO, this.iterations);
    }

    public Optional<Slice> slice(BigInteger length) {
        return Slice.createFromSource(this.source, this.offset, length);
    }

    public String toString() {
        String iterationString = this.iterations.isEmpty() ? "" : ";iterations:" + this.iterations.toString();
        return this.getClass().getSimpleName() + "(source:" + this.source + ";offset:" + this.offset + ";order:" + this.order + iterationString + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.order, ((ParseState)obj).order) && Objects.equals(this.offset, ((ParseState)obj).offset) && Objects.equals(this.source, ((ParseState)obj).source) && Objects.equals(this.iterations, ((ParseState)obj).iterations);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.order, this.offset, this.source, this.iterations);
    }
}

