/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ParseGraph;
import io.parsingdata.metal.data.ParseItem;
import io.parsingdata.metal.data.Selection;
import io.parsingdata.metal.data.Source;
import io.parsingdata.metal.token.Token;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class ParseReference
implements ParseItem {
    public final BigInteger location;
    public final Source source;
    public final Token definition;

    public ParseReference(BigInteger location, Source source, Token definition) {
        this.location = Util.checkNotNull(location, "location");
        this.source = Util.checkNotNull(source, "source");
        this.definition = Util.checkNotNull(definition, "definition");
    }

    public Optional<ParseItem> resolve(ParseGraph root) {
        return Selection.findItemAtOffset(Selection.getAllRoots(root, this.definition), this.location, this.source).computeResult();
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public ParseReference asReference() {
        return this;
    }

    @Override
    public Token getDefinition() {
        return this.definition;
    }

    public String toString() {
        return "pref(@" + this.location + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.location, ((ParseReference)obj).location) && Objects.equals(this.source, ((ParseReference)obj).source) && Objects.equals(this.definition, ((ParseReference)obj).definition);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.location, this.source, this.definition);
    }
}

