/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Environment;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseItem;
import io.parsingdata.metal.data.ParseReference;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.ParseValue;
import io.parsingdata.metal.token.Token;
import java.util.Objects;
import java.util.Optional;

public class ParseGraph
implements ParseItem {
    public final ParseItem head;
    public final ParseGraph tail;
    public final boolean branched;
    public final Token definition;
    public final long size;
    public static final Token NONE = new Token("NONE", null){

        @Override
        protected Optional<ParseState> parseImpl(Environment environment) {
            throw new IllegalStateException("This placeholder may not be invoked.");
        }

        public String toString() {
            return "None";
        }
    };
    public static final ParseGraph EMPTY = new ParseGraph(NONE);

    private ParseGraph(Token definition) {
        this.head = null;
        this.tail = null;
        this.branched = false;
        this.definition = Util.checkNotNull(definition, "definition");
        this.size = 0L;
    }

    private ParseGraph(ParseItem head, ParseGraph tail, Token definition, boolean branched) {
        this.head = Util.checkNotNull(head, "head");
        this.tail = Util.checkNotNull(tail, "tail");
        this.branched = branched;
        this.definition = Util.checkNotNull(definition, "definition");
        this.size = tail.size + 1L;
    }

    private ParseGraph(ParseItem head, ParseGraph tail, Token definition) {
        this(head, tail, definition, false);
    }

    protected ParseGraph add(ParseValue head) {
        if (this.branched) {
            return new ParseGraph(this.head.asGraph().add(head), this.tail, this.definition, true);
        }
        return new ParseGraph(head, this, this.definition);
    }

    protected ParseGraph add(ParseReference parseReference) {
        if (this.branched) {
            return new ParseGraph(this.head.asGraph().add(parseReference), this.tail, this.definition, true);
        }
        return new ParseGraph(parseReference, this, this.definition);
    }

    protected ParseGraph addBranch(Token definition) {
        if (this.branched) {
            return new ParseGraph(this.head.asGraph().addBranch(definition), this.tail, this.definition, true);
        }
        return new ParseGraph(new ParseGraph(definition), this, this.definition, true);
    }

    protected ParseGraph closeBranch() {
        if (!this.branched) {
            throw new IllegalStateException("Cannot close branch that is not open.");
        }
        if (this.head.asGraph().branched) {
            return new ParseGraph(this.head.asGraph().closeBranch(), this.tail, this.definition, true);
        }
        return new ParseGraph(this.head, this.tail, this.definition, false);
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public Optional<ParseValue> current() {
        return this.current(ImmutableList.create(this)).computeResult();
    }

    private Trampoline<Optional<ParseValue>> current(ImmutableList<ParseItem> items) {
        if (items.isEmpty()) {
            return Trampoline.complete(Optional::empty);
        }
        ParseItem item = (ParseItem)items.head;
        if (item.isValue()) {
            return Trampoline.complete(() -> Optional.of(item.asValue()));
        }
        if (item.isGraph() && !item.asGraph().isEmpty()) {
            return Trampoline.intermediate(() -> this.current(items.tail.add(item.asGraph().tail).add((ParseGraph)item.asGraph().head)));
        }
        return Trampoline.intermediate(() -> this.current(items.tail));
    }

    @Override
    public boolean isGraph() {
        return true;
    }

    @Override
    public ParseGraph asGraph() {
        return this;
    }

    @Override
    public Token getDefinition() {
        return this.definition;
    }

    public String toString() {
        if (this.equals(EMPTY)) {
            return "pg(EMPTY)";
        }
        if (this.isEmpty()) {
            return "pg(terminator:" + this.definition.getClass().getSimpleName() + ")";
        }
        return "pg(" + this.head + "," + this.tail + "," + this.branched + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.head, ((ParseGraph)obj).head) && Objects.equals(this.tail, ((ParseGraph)obj).tail) && Objects.equals(this.branched, ((ParseGraph)obj).branched) && Objects.equals(this.definition, ((ParseGraph)obj).definition);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.head, this.tail, this.branched, this.definition);
    }
}

