/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Selection;
import java.util.Objects;

public class ImmutableList<T> {
    public final T head;
    public final ImmutableList<T> tail;
    public final long size;

    public ImmutableList() {
        this.head = null;
        this.tail = null;
        this.size = 0L;
    }

    private ImmutableList(T head, ImmutableList<T> tail) {
        this.head = Util.checkNotNull(head, "head");
        this.tail = Util.checkNotNull(tail, "tail");
        this.size = tail.size + 1L;
    }

    public static <T> ImmutableList<T> create(T head) {
        return new ImmutableList<T>().add(Util.checkNotNull(head, "head"));
    }

    public static <T> ImmutableList<T> create(T[] array) {
        return ImmutableList.createFromArray(new ImmutableList<T>(), Util.checkNotNull(array, "array"), array.length - 1).computeResult();
    }

    private static <T> Trampoline<ImmutableList<T>> createFromArray(ImmutableList<T> list, T[] array, int index) {
        if (index < 0) {
            return Trampoline.complete(() -> list);
        }
        return Trampoline.intermediate(() -> ImmutableList.createFromArray(list.add(array[index]), array, index - 1));
    }

    public ImmutableList<T> add(T head) {
        return new ImmutableList<T>(Util.checkNotNull(head, "head"), this);
    }

    public ImmutableList<T> add(ImmutableList<T> list) {
        Util.checkNotNull(list, "list");
        if (this.isEmpty()) {
            return list;
        }
        return this.addRecursive(Selection.reverse(list)).computeResult();
    }

    private Trampoline<ImmutableList<T>> addRecursive(ImmutableList<T> list) {
        if (list.isEmpty()) {
            return Trampoline.complete(() -> this);
        }
        return Trampoline.intermediate(() -> super.addRecursive(list.tail));
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public String toString() {
        return this.isEmpty() ? "" : ">" + this.head + this.tail;
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.head, ((ImmutableList)obj).head) && Objects.equals(this.tail, ((ImmutableList)obj).tail);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.head, this.tail);
    }
}

