/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.callback.Callbacks;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.token.Token;

public class Environment {
    public final String scope;
    public final ParseState parseState;
    public final Callbacks callbacks;
    public final Encoding encoding;

    public Environment(String scope, ParseState parseState, Callbacks callbacks, Encoding encoding) {
        this.scope = Util.checkNotNull(scope, "scope");
        this.parseState = Util.checkNotNull(parseState, "parseState");
        this.callbacks = Util.checkNotNull(callbacks, "callbacks");
        this.encoding = Util.checkNotNull(encoding, "encoding");
    }

    public Environment(String scope, ParseState parseState, Encoding encoding) {
        this(scope, parseState, Callbacks.NONE, encoding);
    }

    public Environment(ParseState parseState, Callbacks callbacks, Encoding encoding) {
        this("", parseState, callbacks, encoding);
    }

    public Environment(ParseState parseState, Encoding encoding) {
        this(parseState, Callbacks.NONE, encoding);
    }

    public Environment withParseState(ParseState parseState) {
        return new Environment(this.scope, parseState, this.callbacks, this.encoding);
    }

    public Environment withEncoding(Encoding encoding) {
        return new Environment(this.scope, this.parseState, this.callbacks, encoding);
    }

    public Environment addBranch(Token token) {
        return this.withParseState(this.parseState.addBranch(token));
    }

    public Environment extendScope(String name) {
        return new Environment(this.scope + (this.scope.isEmpty() || name.isEmpty() ? "" : ".") + name, this.parseState, this.callbacks, this.encoding);
    }
}

