/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.Source;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.math.BigInteger;
import java.util.Objects;

public class DataExpressionSource
extends Source {
    public final ValueExpression dataExpression;
    public final int index;
    public final ParseState parseState;
    public final Encoding encoding;
    private byte[] cache = null;

    public DataExpressionSource(ValueExpression dataExpression, int index, ParseState parseState, Encoding encoding) {
        this.dataExpression = Util.checkNotNull(dataExpression, "dataExpression");
        this.index = index;
        this.parseState = Util.checkNotNull(parseState, "parseState");
        this.encoding = Util.checkNotNull(encoding, "encoding");
    }

    @Override
    protected byte[] getData(BigInteger offset, BigInteger length) {
        Util.checkNotNegative(offset, "offset");
        byte[] data = this.getValue();
        if (Util.checkNotNegative(length, "length").add(offset).compareTo(BigInteger.valueOf(data.length)) > 0) {
            throw new IllegalStateException(Util.format("Data to read is not available ([offset=%d;length=%d;source=%s).", offset, length, this));
        }
        byte[] outputData = new byte[length.intValueExact()];
        System.arraycopy(data, offset.intValueExact(), outputData, 0, outputData.length);
        return outputData;
    }

    @Override
    protected boolean isAvailable(BigInteger offset, BigInteger length) {
        return Util.checkNotNegative(offset, "offset").add(Util.checkNotNegative(length, "length")).compareTo(BigInteger.valueOf(this.getValue().length)) <= 0;
    }

    private synchronized byte[] getValue() {
        if (this.cache == null) {
            ImmutableList<Value> results = this.dataExpression.eval(this.parseState, this.encoding);
            if (results.size <= (long)this.index) {
                throw new IllegalStateException(Util.format("ValueExpression dataExpression yields %d result(s) (expected at least %d).", results.size, this.index + 1));
            }
            Value cacheValue = this.getValueAtIndex(results, this.index, 0).computeResult();
            if (cacheValue.equals(NotAValue.NOT_A_VALUE)) {
                throw new IllegalStateException(Util.format("ValueExpression dataExpression yields NOT_A_VALUE at index %d.", this.index));
            }
            this.cache = cacheValue.value();
        }
        return this.cache;
    }

    private Trampoline<Value> getValueAtIndex(ImmutableList<Value> results, int index, int current) {
        if (index == current) {
            return Trampoline.complete(() -> (Value)results.head);
        }
        return Trampoline.intermediate(() -> this.getValueAtIndex(results.tail, index, current + 1));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.dataExpression + "[" + this.index + "](" + this.parseState + "," + this.encoding + "))";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.dataExpression, ((DataExpressionSource)obj).dataExpression) && Objects.equals(this.index, ((DataExpressionSource)obj).index) && Objects.equals(this.parseState, ((DataExpressionSource)obj).parseState) && Objects.equals(this.encoding, ((DataExpressionSource)obj).encoding);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.dataExpression, this.index, this.parseState, this.encoding);
    }
}

