/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.Source;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public class ConstantSource
extends Source {
    private final byte[] data;

    public ConstantSource(byte[] data) {
        this.data = Util.checkNotNull(data, "data");
    }

    @Override
    protected byte[] getData(BigInteger offset, BigInteger length) {
        if (!this.isAvailable(offset, length)) {
            throw new IllegalStateException(Util.format("Data to read is not available ([offset=%d;length=%d;source=%s).", offset, length, this));
        }
        byte[] outputData = new byte[length.intValueExact()];
        System.arraycopy(this.data, offset.intValueExact(), outputData, 0, outputData.length);
        return outputData;
    }

    @Override
    protected boolean isAvailable(BigInteger offset, BigInteger length) {
        return Util.checkNotNegative(length, "length").add(Util.checkNotNegative(offset, "offset")).compareTo(BigInteger.valueOf(this.data.length)) <= 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(0x" + Util.bytesToHexString(this.data) + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Arrays.equals(this.data, ((ConstantSource)obj).data);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), Arrays.hashCode(this.data));
    }
}

