/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Trampoline;
import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ImmutableList;
import io.parsingdata.metal.data.Selection;
import io.parsingdata.metal.data.Source;
import io.parsingdata.metal.expression.value.NotAValue;
import io.parsingdata.metal.expression.value.Value;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class ConcatenatedValueSource
extends Source {
    public final ImmutableList<Value> values;
    public final BigInteger length;

    private ConcatenatedValueSource(ImmutableList<Value> values, BigInteger length) {
        this.values = Util.checkNotNull(values, "values");
        this.length = Util.checkNotNegative(length, "length");
    }

    public static Optional<ConcatenatedValueSource> create(ImmutableList<Value> inputValues) {
        ImmutableList<Value> values = Selection.reverse(inputValues);
        BigInteger length = ConcatenatedValueSource.calculateTotalSize(values);
        if (length.compareTo(BigInteger.ZERO) == 0) {
            return Optional.empty();
        }
        return Optional.of(new ConcatenatedValueSource(values, length));
    }

    private static BigInteger calculateTotalSize(ImmutableList<Value> values) {
        return ConcatenatedValueSource.calculateTotalSize(values, BigInteger.ZERO).computeResult();
    }

    private static Trampoline<BigInteger> calculateTotalSize(ImmutableList<Value> values, BigInteger size) {
        if (values.isEmpty()) {
            return Trampoline.complete(() -> size);
        }
        if (((Value)values.head).equals(NotAValue.NOT_A_VALUE)) {
            return Trampoline.complete(() -> BigInteger.ZERO);
        }
        return Trampoline.intermediate(() -> ConcatenatedValueSource.calculateTotalSize(values.tail, size.add(((Value)values.head).slice().length)));
    }

    @Override
    protected byte[] getData(BigInteger offset, BigInteger length) {
        if (!this.isAvailable(offset, length)) {
            throw new IllegalStateException(Util.format("Data to read is not available (offset=%d;length=%d;source=%s).", offset, length, this));
        }
        return this.getData(this.values, BigInteger.ZERO, BigInteger.ZERO, offset, length, new byte[length.intValueExact()]).computeResult();
    }

    private Trampoline<byte[]> getData(ImmutableList<Value> values, BigInteger currentOffset, BigInteger currentDest, BigInteger offset, BigInteger length, byte[] output) {
        if (length.compareTo(BigInteger.ZERO) <= 0) {
            return Trampoline.complete(() -> output);
        }
        if (currentOffset.add(((Value)values.head).slice().length).compareTo(offset) <= 0) {
            return Trampoline.intermediate(() -> this.getData(values.tail, currentOffset.add(((Value)values.head).slice().length), currentDest, offset, length, output));
        }
        BigInteger localOffset = offset.subtract(currentOffset).compareTo(BigInteger.ZERO) < 0 ? BigInteger.ZERO : offset.subtract(currentOffset);
        BigInteger toCopy = length.compareTo(((Value)values.head).slice().length.subtract(localOffset)) > 0 ? ((Value)values.head).slice().length.subtract(localOffset) : length;
        System.arraycopy(((Value)values.head).slice().getData(), localOffset.intValueExact(), output, currentDest.intValueExact(), toCopy.intValueExact());
        return Trampoline.intermediate(() -> this.getData(values.tail, currentOffset.add(((Value)values.head).slice().length), currentDest.add(toCopy), offset, length.subtract(toCopy), output));
    }

    @Override
    protected boolean isAvailable(BigInteger offset, BigInteger length) {
        return Util.checkNotNegative(length, "length").add(Util.checkNotNegative(offset, "offset")).compareTo(this.length) <= 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.values + "(" + this.length + "))";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.values, ((ConcatenatedValueSource)obj).values) && Objects.equals(this.length, ((ConcatenatedValueSource)obj).length);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.values, this.length);
    }
}

