/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.data;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ByteStream;
import io.parsingdata.metal.data.Source;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.util.Objects;

public class ByteStreamSource
extends Source {
    public final ByteStream input;

    ByteStreamSource(ByteStream input) {
        this.input = Util.checkNotNull(input, "input");
    }

    @Override
    protected byte[] getData(BigInteger offset, BigInteger length) {
        if (!this.isAvailable(offset, length)) {
            throw new IllegalStateException(Util.format("Data to read is not available ([offset=%d;length=%d;source=%s).", offset, length, this));
        }
        try {
            return this.input.read(offset, length.intValueExact());
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    @Override
    protected boolean isAvailable(BigInteger offset, BigInteger length) {
        return this.input.isAvailable(Util.checkNotNegative(offset, "offset"), Util.checkNotNegative(length, "length").intValueExact());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.input + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass(this, obj) && Objects.equals(this.input, ((ByteStreamSource)obj).input);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.input);
    }
}

