/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal;

import io.parsingdata.metal.data.ParseState;
import io.parsingdata.metal.data.Slice;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.value.CoreValue;
import io.parsingdata.metal.expression.value.UnaryValueExpression;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Optional;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class Util {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private Util() {
    }

    public static <T> T checkNotNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(Util.format("Argument %s may not be null.", name));
        }
        return argument;
    }

    public static <T> T[] checkContainsNoNulls(T[] arguments, String name) {
        Util.checkNotNull(arguments, name);
        for (T argument : arguments) {
            if (argument != null) continue;
            throw new IllegalArgumentException(Util.format("Value in array %s may not be null.", name));
        }
        return arguments;
    }

    public static String checkNotEmpty(String argument, String name) {
        if (Util.checkNotNull(argument, name).isEmpty()) {
            throw new IllegalArgumentException(Util.format("Argument %s may not be empty.", name));
        }
        return argument;
    }

    public static boolean notNullAndSameClass(Object object, Object other) {
        return other != null && object.getClass() == other.getClass();
    }

    public static BigInteger checkNotNegative(BigInteger argument, String name) {
        if (Util.checkNotNull(argument, name).compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException(Util.format("Argument %s may not be negative.", name));
        }
        return argument;
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.ENGLISH, format, args);
    }

    public static String bytesToHexString(byte[] bytes) {
        Util.checkNotNull(bytes, "bytes");
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static ValueExpression inflate(ValueExpression target) {
        return new UnaryValueExpression(target){

            @Override
            public Optional<Value> eval(Value value, ParseState parseState, Encoding encoding) {
                Inflater inf = new Inflater(true);
                inf.setInput(value.value());
                byte[] dataReceiver = new byte[512];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while (!inf.finished()) {
                    try {
                        int processed = inf.inflate(dataReceiver);
                        out.write(dataReceiver, 0, processed);
                    }
                    catch (DataFormatException e) {
                        return Optional.empty();
                    }
                }
                return Optional.of(new CoreValue(Slice.createFromBytes(out.toByteArray()), encoding));
            }
        };
    }

    public static Optional<ParseState> success(ParseState parseState) {
        return Optional.of(parseState);
    }

    public static Optional<ParseState> failure() {
        return Optional.empty();
    }
}

