/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal;

public interface Trampoline<T> {
    public T result();

    public boolean hasNext();

    public Trampoline<T> next();

    default public T computeResult() {
        Trampoline<T> current = this;
        while (current.hasNext()) {
            current = current.next();
        }
        return current.result();
    }

    public static <T> Trampoline<T> complete(CompletedTrampoline<T> completedTrampoline) {
        return completedTrampoline;
    }

    public static <T> Trampoline<T> intermediate(IntermediateTrampoline<T> intermediateTrampoline) {
        return intermediateTrampoline;
    }

    @FunctionalInterface
    public static interface IntermediateTrampoline<T>
    extends Trampoline<T> {
        @Override
        default public T result() {
            throw new UnsupportedOperationException("An IntermediateTrampoline does not have a result.");
        }

        @Override
        default public boolean hasNext() {
            return true;
        }
    }

    @FunctionalInterface
    public static interface CompletedTrampoline<T>
    extends Trampoline<T> {
        @Override
        default public boolean hasNext() {
            return false;
        }

        @Override
        default public Trampoline<T> next() {
            throw new UnsupportedOperationException("A CompletedTrampoline does not have a next computation.");
        }
    }
}

