/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal;

import io.parsingdata.metal.data.Slice;
import io.parsingdata.metal.encoding.Encoding;
import io.parsingdata.metal.expression.Expression;
import io.parsingdata.metal.expression.True;
import io.parsingdata.metal.expression.comparison.ComparisonExpression;
import io.parsingdata.metal.expression.comparison.Eq;
import io.parsingdata.metal.expression.comparison.EqNum;
import io.parsingdata.metal.expression.comparison.EqStr;
import io.parsingdata.metal.expression.comparison.GtEqNum;
import io.parsingdata.metal.expression.comparison.GtNum;
import io.parsingdata.metal.expression.comparison.LtEqNum;
import io.parsingdata.metal.expression.comparison.LtNum;
import io.parsingdata.metal.expression.logical.BinaryLogicalExpression;
import io.parsingdata.metal.expression.logical.Or;
import io.parsingdata.metal.expression.logical.UnaryLogicalExpression;
import io.parsingdata.metal.expression.value.BinaryValueExpression;
import io.parsingdata.metal.expression.value.Bytes;
import io.parsingdata.metal.expression.value.Cat;
import io.parsingdata.metal.expression.value.Const;
import io.parsingdata.metal.expression.value.ConstantFactory;
import io.parsingdata.metal.expression.value.CoreValue;
import io.parsingdata.metal.expression.value.Elvis;
import io.parsingdata.metal.expression.value.Expand;
import io.parsingdata.metal.expression.value.FoldCat;
import io.parsingdata.metal.expression.value.FoldLeft;
import io.parsingdata.metal.expression.value.FoldRight;
import io.parsingdata.metal.expression.value.Reverse;
import io.parsingdata.metal.expression.value.Scope;
import io.parsingdata.metal.expression.value.SingleValueExpression;
import io.parsingdata.metal.expression.value.UnaryValueExpression;
import io.parsingdata.metal.expression.value.Value;
import io.parsingdata.metal.expression.value.ValueExpression;
import io.parsingdata.metal.expression.value.arithmetic.Add;
import io.parsingdata.metal.expression.value.arithmetic.Div;
import io.parsingdata.metal.expression.value.arithmetic.Mod;
import io.parsingdata.metal.expression.value.arithmetic.Mul;
import io.parsingdata.metal.expression.value.arithmetic.Neg;
import io.parsingdata.metal.expression.value.bitwise.And;
import io.parsingdata.metal.expression.value.bitwise.Not;
import io.parsingdata.metal.expression.value.bitwise.ShiftLeft;
import io.parsingdata.metal.expression.value.bitwise.ShiftRight;
import io.parsingdata.metal.expression.value.reference.Count;
import io.parsingdata.metal.expression.value.reference.CurrentIteration;
import io.parsingdata.metal.expression.value.reference.CurrentOffset;
import io.parsingdata.metal.expression.value.reference.First;
import io.parsingdata.metal.expression.value.reference.Last;
import io.parsingdata.metal.expression.value.reference.Len;
import io.parsingdata.metal.expression.value.reference.Nth;
import io.parsingdata.metal.expression.value.reference.Offset;
import io.parsingdata.metal.expression.value.reference.Ref;
import io.parsingdata.metal.expression.value.reference.Self;
import io.parsingdata.metal.token.Cho;
import io.parsingdata.metal.token.Def;
import io.parsingdata.metal.token.Post;
import io.parsingdata.metal.token.Pre;
import io.parsingdata.metal.token.Rep;
import io.parsingdata.metal.token.RepN;
import io.parsingdata.metal.token.Seq;
import io.parsingdata.metal.token.Sub;
import io.parsingdata.metal.token.Tie;
import io.parsingdata.metal.token.Token;
import io.parsingdata.metal.token.TokenRef;
import io.parsingdata.metal.token.Until;
import io.parsingdata.metal.token.While;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;

public final class Shorthand {
    public static final Token EMPTY = Shorthand.def("__EMPTY__", 0L);
    public static final SingleValueExpression SELF = new Self();
    public static final SingleValueExpression CURRENT_OFFSET = new CurrentOffset();
    public static final SingleValueExpression CURRENT_ITERATION = new CurrentIteration(Shorthand.con(0L));
    public static final Expression TRUE = new True();

    private Shorthand() {
    }

    public static Token def(String name, SingleValueExpression size, Expression predicate, Encoding encoding) {
        return Shorthand.post(Shorthand.def(name, size, encoding), predicate);
    }

    public static Token def(String name, SingleValueExpression size, Expression predicate) {
        return Shorthand.def(name, size, predicate, null);
    }

    public static Token def(String name, SingleValueExpression size, Encoding encoding) {
        return new Def(name, size, encoding);
    }

    public static Token def(String name, SingleValueExpression size) {
        return Shorthand.def(name, size, (Encoding)null);
    }

    public static Token def(String name, long size, Expression predicate, Encoding encoding) {
        return Shorthand.def(name, Shorthand.con(size), predicate, encoding);
    }

    public static Token def(String name, long size, Expression predicate) {
        return Shorthand.def(name, size, predicate, null);
    }

    public static Token def(String name, long size, Encoding encoding) {
        return Shorthand.def(name, Shorthand.con(size), encoding);
    }

    public static Token def(String name, long size) {
        return Shorthand.def(name, size, (Encoding)null);
    }

    public static Token nod(SingleValueExpression size) {
        return Shorthand.def("__EMPTY__", size);
    }

    public static Token nod(long size) {
        return Shorthand.nod(Shorthand.con(size));
    }

    public static Token cho(String name, Encoding encoding, Token token1, Token token2, Token ... tokens) {
        return new Cho(name, encoding, token1, token2, tokens);
    }

    public static Token cho(String name, Token token1, Token token2, Token ... tokens) {
        return Shorthand.cho(name, null, token1, token2, tokens);
    }

    public static Token cho(Encoding encoding, Token token1, Token token2, Token ... tokens) {
        return Shorthand.cho("", encoding, token1, token2, tokens);
    }

    public static Token cho(Token token1, Token token2, Token ... tokens) {
        return Shorthand.cho((Encoding)null, token1, token2, tokens);
    }

    public static Token rep(String name, Token token, Encoding encoding) {
        return new Rep(name, token, encoding);
    }

    public static Token rep(String name, Token token) {
        return Shorthand.rep(name, token, null);
    }

    public static Token rep(Token token, Encoding encoding) {
        return Shorthand.rep("", token, encoding);
    }

    public static Token rep(Token token) {
        return Shorthand.rep(token, null);
    }

    public static Token repn(String name, Token token, SingleValueExpression n, Encoding encoding) {
        return new RepN(name, token, n, encoding);
    }

    public static Token repn(String name, Token token, SingleValueExpression n) {
        return Shorthand.repn(name, token, n, null);
    }

    public static Token repn(Token token, SingleValueExpression n, Encoding encoding) {
        return Shorthand.repn("", token, n, encoding);
    }

    public static Token repn(Token token, SingleValueExpression n) {
        return Shorthand.repn(token, n, null);
    }

    public static Token seq(String name, Encoding encoding, Token token1, Token token2, Token ... tokens) {
        return new Seq(name, encoding, token1, token2, tokens);
    }

    public static Token seq(String name, Token token1, Token token2, Token ... tokens) {
        return Shorthand.seq(name, null, token1, token2, tokens);
    }

    public static Token seq(Encoding encoding, Token token1, Token token2, Token ... tokens) {
        return Shorthand.seq("", encoding, token1, token2, tokens);
    }

    public static Token seq(Token token1, Token token2, Token ... tokens) {
        return Shorthand.seq((Encoding)null, token1, token2, tokens);
    }

    public static Token sub(String name, Token token, ValueExpression address, Encoding encoding) {
        return new Sub(name, token, address, encoding);
    }

    public static Token sub(String name, Token token, ValueExpression address) {
        return Shorthand.sub(name, token, address, null);
    }

    public static Token sub(Token token, ValueExpression address, Encoding encoding) {
        return Shorthand.sub("", token, address, encoding);
    }

    public static Token sub(Token token, ValueExpression address) {
        return Shorthand.sub(token, address, null);
    }

    public static Token pre(String name, Token token, Expression predicate, Encoding encoding) {
        return new Pre(name, token, predicate, encoding);
    }

    public static Token pre(String name, Token token, Expression predicate) {
        return Shorthand.pre(name, token, predicate, null);
    }

    public static Token pre(Token token, Expression predicate, Encoding encoding) {
        return Shorthand.pre("", token, predicate, encoding);
    }

    public static Token pre(Token token, Expression predicate) {
        return Shorthand.pre(token, predicate, null);
    }

    public static Token post(String name, Token token, Expression predicate, Encoding encoding) {
        return new Post(name, token, predicate, encoding);
    }

    public static Token post(String name, Token token, Expression predicate) {
        return Shorthand.post(name, token, predicate, null);
    }

    public static Token post(Token token, Expression predicate, Encoding encoding) {
        return Shorthand.post("", token, predicate, encoding);
    }

    public static Token post(Token token, Expression predicate) {
        return Shorthand.post(token, predicate, null);
    }

    public static Token whl(String name, Token token, Expression predicate, Encoding encoding) {
        return new While(name, token, predicate, encoding);
    }

    public static Token whl(String name, Token token, Expression predicate) {
        return Shorthand.whl(name, token, predicate, null);
    }

    public static Token whl(Token token, Expression predicate, Encoding encoding) {
        return Shorthand.whl("", token, predicate, encoding);
    }

    public static Token whl(Token token, Expression predicate) {
        return Shorthand.whl("", token, predicate);
    }

    public static Token opt(String name, Token token, Encoding encoding) {
        return Shorthand.cho(name, encoding, token, EMPTY, new Token[0]);
    }

    public static Token opt(String name, Token token) {
        return Shorthand.opt(name, token, null);
    }

    public static Token opt(Token token, Encoding encoding) {
        return Shorthand.opt("", token, encoding);
    }

    public static Token opt(Token token) {
        return Shorthand.opt(token, null);
    }

    public static Token token(String tokenName) {
        return new TokenRef("", tokenName, null);
    }

    public static Token tie(String name, Token token, ValueExpression dataExpression, Encoding encoding) {
        return new Tie(name, token, dataExpression, encoding);
    }

    public static Token tie(String name, Token token, ValueExpression dataExpression) {
        return Shorthand.tie(name, token, dataExpression, null);
    }

    public static Token tie(Token token, ValueExpression dataExpression, Encoding encoding) {
        return Shorthand.tie("", token, dataExpression, encoding);
    }

    public static Token tie(Token token, ValueExpression dataExpression) {
        return Shorthand.tie(token, dataExpression, null);
    }

    public static Token until(String name, ValueExpression initialSize, ValueExpression stepSize, ValueExpression maxSize, Token terminator, Encoding encoding) {
        return new Until(name, initialSize, stepSize, maxSize, terminator, encoding);
    }

    public static Token until(String name, ValueExpression initialSize, ValueExpression stepSize, ValueExpression maxSize, Token terminator) {
        return Shorthand.until(name, initialSize, stepSize, maxSize, terminator, null);
    }

    public static Token until(String name, ValueExpression initialSize, ValueExpression stepSize, Token terminator, Encoding encoding) {
        return Shorthand.until(name, initialSize, stepSize, null, terminator, encoding);
    }

    public static Token until(String name, ValueExpression initialSize, ValueExpression stepSize, Token terminator) {
        return Shorthand.until(name, initialSize, stepSize, null, terminator, null);
    }

    public static Token until(String name, ValueExpression initialSize, Token terminator, Encoding encoding) {
        return Shorthand.until(name, initialSize, null, terminator, encoding);
    }

    public static Token until(String name, ValueExpression initialSize, Token terminator) {
        return Shorthand.until(name, initialSize, null, terminator, null);
    }

    public static Token until(String name, Token terminator, Encoding encoding) {
        return Shorthand.until(name, null, terminator, encoding);
    }

    public static Token until(String name, Token terminator) {
        return Shorthand.until(name, terminator, null);
    }

    public static Token when(String name, Token token, Expression predicate, Encoding encoding) {
        return Shorthand.cho(name, encoding, Shorthand.pre(Shorthand.def("__EMPTY__", 0L), Shorthand.not(predicate)), token, new Token[0]);
    }

    public static Token when(String name, Token token, Expression predicate) {
        return Shorthand.when(name, token, predicate, null);
    }

    public static Token when(Token token, Expression predicate, Encoding encoding) {
        return Shorthand.when("__EMPTY__", token, predicate, encoding);
    }

    public static Token when(Token token, Expression predicate) {
        return Shorthand.when(token, predicate, null);
    }

    public static BinaryValueExpression add(ValueExpression left, ValueExpression right) {
        return new Add(left, right);
    }

    public static BinaryValueExpression div(ValueExpression left, ValueExpression right) {
        return new Div(left, right);
    }

    public static BinaryValueExpression mul(ValueExpression left, ValueExpression right) {
        return new Mul(left, right);
    }

    public static BinaryValueExpression sub(ValueExpression left, ValueExpression right) {
        return new io.parsingdata.metal.expression.value.arithmetic.Sub(left, right);
    }

    public static BinaryValueExpression mod(ValueExpression left, ValueExpression right) {
        return new Mod(left, right);
    }

    public static UnaryValueExpression neg(ValueExpression operand) {
        return new Neg(operand);
    }

    public static BinaryValueExpression and(ValueExpression left, ValueExpression right) {
        return new And(left, right);
    }

    public static BinaryValueExpression or(ValueExpression left, ValueExpression right) {
        return new io.parsingdata.metal.expression.value.bitwise.Or(left, right);
    }

    public static UnaryValueExpression not(ValueExpression operand) {
        return new Not(operand);
    }

    public static BinaryValueExpression shl(ValueExpression left, ValueExpression right) {
        return new ShiftLeft(left, right);
    }

    public static BinaryValueExpression shr(ValueExpression left, ValueExpression right) {
        return new ShiftRight(left, right);
    }

    public static SingleValueExpression con(long value) {
        return Shorthand.con(value, Encoding.DEFAULT_ENCODING);
    }

    public static SingleValueExpression con(long value, Encoding encoding) {
        return Shorthand.con(ConstantFactory.createFromNumeric(value, encoding));
    }

    public static SingleValueExpression con(String value) {
        return Shorthand.con(value, Encoding.DEFAULT_ENCODING);
    }

    public static SingleValueExpression con(String value, Encoding encoding) {
        return Shorthand.con(ConstantFactory.createFromString(value, encoding));
    }

    public static SingleValueExpression con(Value value) {
        return new Const(value);
    }

    public static SingleValueExpression con(Encoding encoding, int ... values) {
        return new Const(new CoreValue(Slice.createFromBytes(Shorthand.toByteArray(values)), encoding));
    }

    public static SingleValueExpression con(int ... values) {
        return Shorthand.con(Encoding.DEFAULT_ENCODING, values);
    }

    public static SingleValueExpression con(byte[] value) {
        return Shorthand.con(value, Encoding.DEFAULT_ENCODING);
    }

    public static SingleValueExpression con(byte[] value, Encoding encoding) {
        return Shorthand.con(ConstantFactory.createFromBytes(value, encoding));
    }

    public static ValueExpression len(ValueExpression operand) {
        return new Len(operand);
    }

    public static Ref.NameRef ref(String name) {
        return Shorthand.ref(name, null);
    }

    public static Ref.NameRef ref(String name, ValueExpression limit) {
        return new Ref.NameRef(name, limit);
    }

    public static Ref.DefinitionRef ref(Token definition) {
        return Shorthand.ref(definition, null);
    }

    public static Ref.DefinitionRef ref(Token definition, ValueExpression limit) {
        return new Ref.DefinitionRef(definition, limit);
    }

    public static SingleValueExpression first(ValueExpression operand) {
        return new First(operand);
    }

    public static SingleValueExpression last(ValueExpression operand) {
        return new Last(operand);
    }

    public static SingleValueExpression last(Ref.NameRef operand) {
        return new Last(new Ref.NameRef((String)operand.reference, Shorthand.con(1L)));
    }

    public static SingleValueExpression last(Ref.DefinitionRef operand) {
        return new Last(new Ref.DefinitionRef((Token)operand.reference, Shorthand.con(1L)));
    }

    public static ValueExpression nth(ValueExpression values, ValueExpression indices) {
        return new Nth(values, indices);
    }

    public static ValueExpression offset(ValueExpression operand) {
        return new Offset(operand);
    }

    public static SingleValueExpression iteration(int level) {
        return Shorthand.iteration(Shorthand.con((long)level));
    }

    public static SingleValueExpression iteration(SingleValueExpression level) {
        return new CurrentIteration(level);
    }

    public static ValueExpression cat(ValueExpression left, ValueExpression right) {
        return new Cat(left, right);
    }

    public static SingleValueExpression cat(ValueExpression operand) {
        return new FoldCat(operand);
    }

    public static ValueExpression elvis(ValueExpression left, ValueExpression right) {
        return new Elvis(left, right);
    }

    public static SingleValueExpression count(ValueExpression operand) {
        return new Count(operand);
    }

    public static SingleValueExpression foldLeft(ValueExpression values, BinaryOperator<ValueExpression> reducer) {
        return new FoldLeft(values, reducer, null);
    }

    public static SingleValueExpression foldLeft(ValueExpression values, BinaryOperator<ValueExpression> reducer, SingleValueExpression initial) {
        return new FoldLeft(values, reducer, initial);
    }

    public static SingleValueExpression foldRight(ValueExpression values, BinaryOperator<ValueExpression> reducer) {
        return new FoldRight(values, reducer, null);
    }

    public static SingleValueExpression foldRight(ValueExpression values, BinaryOperator<ValueExpression> reducer, SingleValueExpression initial) {
        return new FoldRight(values, reducer, initial);
    }

    public static SingleValueExpression fold(ValueExpression values, BinaryOperator<ValueExpression> reducer) {
        return Shorthand.foldRight(values, reducer);
    }

    public static SingleValueExpression fold(ValueExpression values, BinaryOperator<ValueExpression> reducer, SingleValueExpression initial) {
        return Shorthand.foldRight(values, reducer, initial);
    }

    public static ValueExpression rev(ValueExpression values) {
        return new Reverse(values);
    }

    public static ValueExpression exp(ValueExpression base, SingleValueExpression count) {
        return new Expand(base, count);
    }

    public static BinaryValueExpression mapLeft(BiFunction<ValueExpression, ValueExpression, BinaryValueExpression> func, ValueExpression left, ValueExpression rightExpand) {
        return func.apply(left, Shorthand.exp(rightExpand, Shorthand.count(left)));
    }

    public static BinaryValueExpression mapRight(BiFunction<ValueExpression, ValueExpression, BinaryValueExpression> func, ValueExpression leftExpand, ValueExpression right) {
        return func.apply(Shorthand.exp(leftExpand, Shorthand.count(right)), right);
    }

    public static ValueExpression bytes(ValueExpression operand) {
        return new Bytes(operand);
    }

    public static ValueExpression scope(ValueExpression scopedValueExpression, SingleValueExpression scopeSize) {
        return new Scope(scopedValueExpression, scopeSize);
    }

    public static BinaryLogicalExpression and(Expression left, Expression right) {
        return new io.parsingdata.metal.expression.logical.And(left, right);
    }

    public static BinaryLogicalExpression or(Expression left, Expression right) {
        return new Or(left, right);
    }

    public static UnaryLogicalExpression not(Expression operand) {
        return new io.parsingdata.metal.expression.logical.Not(operand);
    }

    public static ComparisonExpression eq(ValueExpression predicate) {
        return new Eq(null, predicate);
    }

    public static ComparisonExpression eq(ValueExpression value, ValueExpression predicate) {
        return new Eq(value, predicate);
    }

    public static ComparisonExpression eqStr(ValueExpression predicate) {
        return new EqStr(null, predicate);
    }

    public static ComparisonExpression eqStr(ValueExpression value, ValueExpression predicate) {
        return new EqStr(value, predicate);
    }

    public static ComparisonExpression eqNum(ValueExpression predicate) {
        return new EqNum(null, predicate);
    }

    public static ComparisonExpression eqNum(ValueExpression value, ValueExpression predicate) {
        return new EqNum(value, predicate);
    }

    public static ComparisonExpression gtEqNum(ValueExpression predicate) {
        return new GtEqNum(null, predicate);
    }

    public static ComparisonExpression gtEqNum(ValueExpression value, ValueExpression predicate) {
        return new GtEqNum(value, predicate);
    }

    public static ComparisonExpression gtNum(ValueExpression predicate) {
        return new GtNum(null, predicate);
    }

    public static ComparisonExpression gtNum(ValueExpression value, ValueExpression predicate) {
        return new GtNum(value, predicate);
    }

    public static ComparisonExpression ltEqNum(ValueExpression predicate) {
        return new LtEqNum(null, predicate);
    }

    public static ComparisonExpression ltEqNum(ValueExpression value, ValueExpression predicate) {
        return new LtEqNum(value, predicate);
    }

    public static ComparisonExpression ltNum(ValueExpression predicate) {
        return new LtNum(null, predicate);
    }

    public static ComparisonExpression ltNum(ValueExpression value, ValueExpression predicate) {
        return new LtNum(value, predicate);
    }

    public static byte[] toByteArray(int ... bytes) {
        byte[] outBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            outBytes[i] = (byte)bytes[i];
        }
        return outBytes;
    }
}

