/*
 * Decompiled with CFR 0.152.
 */
package io.parsingdata.metal.util;

import io.parsingdata.metal.Util;
import io.parsingdata.metal.data.ByteStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

public class ReadTrackingByteStream
implements ByteStream {
    private final ByteStream byteStream;
    private final Set<Long> read = new HashSet<Long>();

    public ReadTrackingByteStream(ByteStream byteStream) {
        this.byteStream = (ByteStream)Util.checkNotNull((Object)byteStream, (String)"byteStream");
    }

    public byte[] read(BigInteger offset, int length) throws IOException {
        for (long i = offset.longValueExact(); i < offset.longValueExact() + (long)length; ++i) {
            this.read.add(i);
        }
        return this.byteStream.read(offset, length);
    }

    public boolean containsAll(long ... values) {
        return this.read.containsAll(LongStream.of(values).boxed().collect(Collectors.toList()));
    }

    public boolean containsNone(long ... values) {
        Iterator iterator = LongStream.of(values).boxed().collect(Collectors.toList()).iterator();
        while (iterator.hasNext()) {
            long v = (Long)iterator.next();
            if (!this.read.contains(v)) continue;
            return false;
        }
        return true;
    }

    public boolean isAvailable(BigInteger offset, int length) {
        return this.byteStream.isAvailable(offset, length);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.byteStream + ")";
    }

    public boolean equals(Object obj) {
        return Util.notNullAndSameClass((Object)this, (Object)obj) && Objects.equals(this.byteStream, ((ReadTrackingByteStream)obj).byteStream);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), Objects.hashCode(this.byteStream));
    }
}

